<?php

use baseKRIZAN\Services\Container;
use baseKRIZAN\Database\DatabaseConnection;

use sales\Controllers\Sales;
use sales\Models\DatabaseTableSales;
use sales\Models\DatabaseTableSalesAdmin;
use sales\Models\DatabaseTableFeedback;

use sales\Controllers\Vrsta;
use sales\Controllers\Osoba;
use sales\Controllers\Target;

use sales\Controllers\Bonus;
use sales\Models\DatabaseTableBonus;

use sales\Controllers\TeamBonus;
use sales\Models\DatabaseTableTeamBonus;
use sales\Controllers\TeamBonusFinancije;
use sales\Models\DatabaseTableTeamBonusFinancije;

use sales\Controllers\AgentBonus;
use sales\Models\DatabaseTableAgentBonus;
use sales\Controllers\AgentBonusBodovanje;
use sales\Models\DatabaseTableAgentBonusBodovanje;

return function(Container $container) {
   $logger = $container->get('logger');
   
   // Dohvatimo DatabaseConnection umjesto PDO-a
   $dbConnection = DatabaseConnection::getInstance();
   
   // Ako imamo eventDispatcher, postavimo ga na DatabaseConnection
   if ($container->has('eventDispatcher')) {
       $dbConnection->setServices(
           $container->get('eventDispatcher'),
           $logger
       );
   }
   
   // Initialize BASIC tables using DatabaseConnection
   $salesTable = new DatabaseTableSales($dbConnection, 'prodaja', 'id');
   $vrste2Table = new DatabaseTableSales($dbConnection, 'prodaja_vrste', 'id');
   $osobe2Table = new DatabaseTableSales($dbConnection, 'prodaja_osobe', 'id');
   $targetTable = new DatabaseTableSales($dbConnection, 'prodaja_target', 'id');

   // Initialize SPECIALIZED tables using DatabaseConnection
   $salesAdminTable = new DatabaseTableSalesAdmin($dbConnection, 'prodaja', 'id', 'stdClass', [], $logger);
   $teamBonusTable = new DatabaseTableTeamBonus($dbConnection, 'prodaja', 'id', 'stdClass', [], $logger);
   $teamBonusFinancijeTable = new DatabaseTableTeamBonusFinancije($dbConnection, 'prodaja', 'id', 'stdClass', [], $logger);
   $agentBonusTable = new DatabaseTableAgentBonus($dbConnection, 'prodaja', 'id', 'stdClass', [], $logger);
   $agentBonusBodovanjeTable = new DatabaseTableAgentBonusBodovanje($dbConnection, 'prodaja', 'id', 'stdClass', [], $logger);
   
   // Initialize BONUS tables using specialized model
   $bonusPrijenosTable = new DatabaseTableBonus($dbConnection, 'prodaja_bonus_prijenos', 'id', 'stdClass', [], $logger);
   $bonusP2pTable = new DatabaseTableBonus($dbConnection, 'prodaja_bonus_p2p', 'id', 'stdClass', [], $logger);
   $bonusTomatoTable = new DatabaseTableBonus($dbConnection, 'prodaja_bonus_tomato', 'id', 'stdClass', [], $logger);

   // Initialize FEEDBACK table using specialized model
   $feedbackTable = new DatabaseTableFeedback($dbConnection, 'prodaja_osoba', 'id', 'stdClass', [], $logger);

   // Register ALL tables in container
   $container->addServices([
       // Basic tables
       'salesTable' => $salesTable,
       'vrste2Table' => $vrste2Table,
       'osobe2Table' => $osobe2Table,
       'targetTable' => $targetTable,
       
       // Specialized tables
       'salesAdminTable' => $salesAdminTable,
       'teamBonusTable' => $teamBonusTable,
       'teamBonusFinancijeTable' => $teamBonusFinancijeTable,
       'agentBonusTable' => $agentBonusTable,
       'agentBonusBodovanjeTable' => $agentBonusBodovanjeTable,
       
       // Bonus tables
       'bonusPrijenosTable' => $bonusPrijenosTable,
       'bonusP2pTable' => $bonusP2pTable,
       'bonusTomatoTable' => $bonusTomatoTable,
       
       // Feedback table
       'feedbackTable' => $feedbackTable,
       
       // DODAJ DatabaseConnection kao service
       'salesDatabaseConnection' => $dbConnection
   ]);

   $container->addServices([
       'salesController' => function($container) {
           return new Sales(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('salesTable'),
               $container->get('salesAdminTable'),
               $container->get('vrste2Table'),
               $container->get('osobe2Table'),
               $container->get('validator'),
               $container->get('salesDatabaseConnection'), // DODANO
               $container->get('logger'),
               $container->get('sessionManager')
           );
       },
       'vrsta2Controller' => function($container) {
           return new Vrsta(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('salesTable'),
               $container->get('vrste2Table'),
               $container->get('validator'),
               $container->get('logger'),
               $container->get('sessionManager')
           );
       },
       'osoba2Controller' => function($container) {
           return new Osoba(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('osobe2Table'),
                $container->get('feedbackTable'), // DODANO
                $container->get('validator'),
                $container->get('logger'),
                $container->get('sessionManager')
           );
       },
       'targetController' => function($container) {
           return new Target(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('salesTable'),
               $container->get('targetTable'),
               $container->get('validator'),
               $container->get('logger'),
               $container->get('sessionManager')
           );
       },
       'bonusController' => function($container) {
           return new Bonus(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('salesTable'),
               $container->get('bonusPrijenosTable'),
               $container->get('bonusP2pTable'),
               $container->get('bonusTomatoTable'),
               $container->get('validator'),
               $container->get('logger'),
               $container->get('sessionManager')
           );
       },
       'teamBonusController' => function($container) {
           return new TeamBonus(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('teamBonusTable'),
               $container->get('logger'),
               $container->get('sessionManager')
           );
       },
       'teamBonusFinancijeController' => function($container) {
            return new TeamBonusFinancije(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('teamBonusFinancijeTable'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
       'agentBonusController' => function($container) {
           return new AgentBonus(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('agentBonusTable'),
               $container->get('logger'),
               $container->get('sessionManager')
           );
       },
       'agentBonusBodovanjeController' => function($container) {
           return new AgentBonusBodovanje(
               $container->get('korisniciTable'),
               $container->get('authentication'),
               $container->get('agentBonusBodovanjeTable'),
               $container->get('feedbackTable'), // DODANO za my-bonus integration
               $container->get('logger'),
               $container->get('sessionManager')
           );
       }
   ]);
   
   return [];
};