<?php
// app/config/sales_routes.php

/**
 * Sales application routes configuration with Feedback System
 * 
 * @var \baseKRIZAN\Routing\RouteBuilder $builder
 * @var \baseKRIZAN\Services\Container $container
 */

// =============================================
// WEB RUTE - vraćaju HTML stranice
// =============================================

// Sales agent rute - osnovne prodajne funkcionalnosti (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_kontrolor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_agent]
], function($builder) {
    // Sale edit rute
    $builder->get('sale/edit', ['salesController', 'edit']);
    $builder->get('sale/edit/{id:number}', ['salesController', 'edit']);
    $builder->post('sale/edit', ['salesController', 'saveEdit']);
    $builder->post('sale/edit/{id:number}', ['salesController', 'saveEdit']);
    
    // Sales list rute
    $builder->get('sales/list', ['salesController', 'list']);
});

// Sales supervizor rute (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Vrsta routes
    $builder->get('salevrsta/edit', ['vrsta2Controller', 'edit']);
    $builder->get('salevrsta/edit/{id:number}', ['vrsta2Controller', 'edit']);
    $builder->post('salevrsta/edit', ['vrsta2Controller', 'saveEdit']);
    $builder->post('salevrsta/edit/{id:number}', ['vrsta2Controller', 'saveEdit']);
    $builder->get('salevrsta/list', ['vrsta2Controller', 'list']);
    
    // Sale Osoba rute
    $builder->get('saleosoba/edit', ['osoba2Controller', 'edit']);
    $builder->get('saleosoba/edit/{id:number}', ['osoba2Controller', 'edit']);
    $builder->post('saleosoba/edit', ['osoba2Controller', 'saveEdit']);
    $builder->post('saleosoba/edit/{id:number}', ['osoba2Controller', 'saveEdit']);
    $builder->get('saleosoba/list', ['osoba2Controller', 'list']);

    // Target routes
    $builder->get('saletarget/edit', ['targetController', 'edit']);
    $builder->get('saletarget/edit/{id:number}', ['targetController', 'edit']);
    $builder->post('saletarget/edit', ['targetController', 'saveEdit']);
    $builder->post('saletarget/edit/{id:number}', ['targetController', 'saveEdit']);
    $builder->get('saletarget/list', ['targetController', 'list']);
    
    // NOVO - Bonus routes
    $builder->get('salebonus/list', ['bonusController', 'list']);
    $builder->get('salebonus/edit', ['bonusController', 'edit']);
    $builder->get('salebonus/edit/{id:number}', ['bonusController', 'edit']);
    $builder->post('salebonus/edit', ['bonusController', 'saveEdit']);
    $builder->post('salebonus/edit/{id:number}', ['bonusController', 'saveEdit']);
    $builder->post('salebonus/saveEdit', ['bonusController', 'saveEdit']);
    
    // =============================================
    // FEEDBACK MANAGEMENT ROUTES
    // =============================================
    
    // Feedback AJAX routes
    $builder->post('saleosoba/add-feedback', ['osoba2Controller', 'addFeedback']);
    $builder->post('saleosoba/update-feedback', ['osoba2Controller', 'updateFeedback']);
    $builder->post('saleosoba/delete-feedback', ['osoba2Controller', 'deleteFeedback']);
    $builder->get('saleosoba/feedbacks', ['osoba2Controller', 'getFeedbacks']);
    $builder->get('saleosoba/feedback/{id:number}', ['osoba2Controller', 'getFeedback']);
});

// =============================================
// TEAM BONUS RUTE
// =============================================

// Team Bonus supervizor rute (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Team bonus dashboard
    $builder->get('teambonus', ['teamBonusController', 'index']);
    $builder->get('teambonus/dashboard', ['teamBonusController', 'index']);
    
    // Team bonus detailed report
    $builder->get('teambonus/detail', ['teamBonusController', 'detailReport']);
    
    // Team bonus print view
    $builder->get('teambonus/print', ['teamBonusController', 'print']);
    
    // Team bonus export
    $builder->get('teambonus/export', ['teamBonusController', 'export']);
});

// Team Bonus API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Team bonus statistics
    $builder->post('teambonus/api/stats', ['teamBonusController', 'getStats']);
});

// =============================================
// TEAM BONUS FINANCIJE RUTE
// =============================================

// Team Bonus Financije supervizor rute (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Team bonus financije dashboard
    $builder->get('teambonusfinancije', ['teamBonusFinancijeController', 'index']);
    $builder->get('teambonusfinancije/dashboard', ['teamBonusFinancijeController', 'index']);
    
    // Team bonus financije detailed report
    $builder->get('teambonusfinancije/detail', ['teamBonusFinancijeController', 'detailReport']);
    
    // Team bonus financije print view
    $builder->get('teambonusfinancije/print', ['teamBonusFinancijeController', 'print']);
    
    // Team bonus financije export
    $builder->get('teambonusfinancije/export', ['teamBonusFinancijeController', 'export']);
});

// Team Bonus Financije API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Team bonus financije statistics
    $builder->post('teambonusfinancije/api/stats', ['teamBonusFinancijeController', 'getStats']);
});

// =============================================
// AGENT BONUS RUTE
// =============================================

// Agent Bonus supervizor rute (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Agent bonus dashboard
    $builder->get('agentbonus', ['agentBonusController', 'index']);
    $builder->get('agentbonus/dashboard', ['agentBonusController', 'index']);
    
    // Agent bonus detailed report
    $builder->get('agentbonus/detail', ['agentBonusController', 'detailReport']);
    
    // Agent bonus print view
    $builder->get('agentbonus/print', ['agentBonusController', 'print']);
    
    // Agent bonus export
    $builder->get('agentbonus/export', ['agentBonusController', 'export']);
});

// Agent Bonus API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Agent bonus statistics
    $builder->post('agentbonus/api/stats', ['agentBonusController', 'getStats']);
});

// =============================================
// AGENT BONUS BODOVANJE RUTE - DODATI U sales_routes.php
// =============================================

// Agent Bonus Bodovanje supervizor rute (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Agent bonus bodovanje dashboard
    $builder->get('agentbonusbodovanje', ['agentBonusBodovanjeController', 'index']);
    $builder->get('agentbonusbodovanje/dashboard', ['agentBonusBodovanjeController', 'index']);
    
    // Agent bonus bodovanje detailed report
    $builder->get('agentbonusbodovanje/detail', ['agentBonusBodovanjeController', 'detailReport']);
    
    // Agent bonus bodovanje print view
    $builder->get('agentbonusbodovanje/print', ['agentBonusBodovanjeController', 'print']);
    
    // Agent bonus bodovanje export
    $builder->get('agentbonusbodovanje/export', ['agentBonusBodovanjeController', 'export']);
});

// Agent Bonus Bodovanje API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Agent bonus bodovanje statistics
    $builder->post('agentbonusbodovanje/api/stats', ['agentBonusBodovanjeController', 'getStats']);
});

// Agent Bonus Bodovanje - My Bonus ruta (za agente) - WITH FEEDBACK INTEGRATION
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_kontrolor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_agent]
], function($builder) {
    // My bonus dashboard za agente - sa feedback integrацijom
    $builder->get('agentbonusbodovanje/my-bonus', ['agentBonusBodovanjeController', 'myBonus']);
    
    // API ruta za dobijanje feedback-a za agenta
    $builder->get('agentbonusbodovanje/my-feedback', ['agentBonusBodovanjeController', 'getMyFeedback']);
});

// Sales administrator rute (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_sales_administrator
], function($builder) {
    // Admin panel
    $builder->get('sales/admin', ['salesController', 'admin']);
    $builder->post('salevrsta/delete', ['vrsta2Controller', 'delete']);
    $builder->post('saleosoba/delete', ['osoba2Controller', 'delete']);
    $builder->post('saletarget/delete', ['targetController', 'delete']);
    
    // NOVO - Bonus delete rute
    $builder->post('salebonus/delete', ['bonusController', 'delete']);
});

// =============================================
// API RUTE - vraćaju JSON podatke
// =============================================

// Sales agent API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_kontrolor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_agent]
], function($builder) {
    // Sales data fetch
    $builder->post('sales/api/fetch-sales', ['salesController', 'fetchsales']);
    
    // OIB provjera
    $builder->post('sales/api/check-oib', ['salesController', 'checkOib']);
});

// Sales kontrolor API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor, 
                    \Models\Entity\Korisnik::KORISNIK_sales_kontrolor]
], function($builder) {
    // Inline uređivanje
    $builder->post('sales/api/inline-edit', ['salesController', 'inlineEdit']);
});

// Sales supervizor API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => [\Models\Entity\Korisnik::KORISNIK_sales_administrator, 
                    \Models\Entity\Korisnik::KORISNIK_sales_supervisor]
], function($builder) {
    // Brisanje prodaje
    $builder->post('sale/api/delete', ['salesController', 'delete']);
    
    // NOVO - Bonus API rute
    $builder->post('salebonus/api/analytics', ['bonusController', 'getAnalytics']);
    $builder->post('salebonus/api/export', ['bonusController', 'export']);
});