<?php
namespace tasks\Entity;

use tasks\Models\DatabaseTableTasks;

class Osoba {
	public $id;
	public $name;
	public $radnomjesto;
	public $tvrtka;
	public $area;
	public $orgjedinica;
	public $vidljivost;
	private $zadatciTable;
	private $zadatakOsobeTable;
	private $zadatakVrsteTable;



	public function __construct(DatabaseTableTasks $zadatciTable, DatabaseTableTasks $zadatakOsobeTable, DatabaseTableTasks $zadatakVrsteTable) {
		$this->zadatciTable = $zadatciTable;
		$this->zadatakOsobeTable = $zadatakOsobeTable;
		$this->zadatakVrsteTable = $zadatakVrsteTable;
	}



	public function getZadatcipoOsobi($OrderBy = null ,$limit = null, $offset = null) {
		$zadatakOsobe = $this->zadatakOsobeTable->find('osobaId', $this->id, $OrderBy, $limit, $offset);

		$zadatci = [];

		foreach ($zadatakOsobe as $zadatakOsoba) {
			$zadatak =  $this->zadatciTable->findById($zadatakOsoba->zadatakId);
			if ($zadatak) {
				$zadatci[] = $zadatak;
			}			
		}

		usort($zadatci, [$this, 'sortZadatcipoOsobi']);

		return $zadatci;
	}

	public function getNumZadatcipoOsobi() {
		return $this->zadatakOsobeTable->total('osobaId', $this->id);
	}

	private function sortZadatcipoOsobi($a, $b) {
		$aDate = new \DateTime($a->ticket_date);
		$bDate = new \DateTime($b->ticket_date);

		if ($aDate->getTimestamp() == $bDate->getTimestamp()) {
			return 0;
		}

		return $aDate->getTimestamp() > $bDate->getTimestamp() ? -1 : 1;
	}



}