<?php
namespace tasks\Entity;

use tasks\Models\DatabaseTableTasks;

class Vrsta {
	public $id;
	public $name;
	public $orgjedinica;
	private $zadatciTable;
	private $zadatakVrsteTable;


	public function __construct(DatabaseTableTasks $zadatciTable, DatabaseTableTasks $zadatakVrsteTable) {
		$this->zadatciTable = $zadatciTable;
		$this->zadatakVrsteTable = $zadatakVrsteTable;
	}



	public function getZadatcipoVrsti($OrderBy = null ,$limit = null, $offset = null) {
		$zadatakVrste = $this->zadatakVrsteTable->find('vrstaId', $this->id, $OrderBy, $limit, $offset);

		$zadatci = [];

		foreach ($zadatakVrste as $zadatakVrsta) {
			$zadatak =  $this->zadatciTable->findById($zadatakVrsta->zadatakId);
			if ($zadatak) {
				$zadatci[] = $zadatak;
			}			
		}

		usort($zadatci, [$this, 'sortZadatcipoVrsti']);

		return $zadatci;
	}

	public function getNumZadatcipoVrsti() {
		return $this->zadatakVrsteTable->total('vrstaId', $this->id);
	}

	private function sortZadatcipoVrsti($a, $b) {
		$aDate = new \DateTime($a->ticket_date);
		$bDate = new \DateTime($b->ticket_date);

		if ($aDate->getTimestamp() == $bDate->getTimestamp()) {
			return 0;
		}

		return $aDate->getTimestamp() > $bDate->getTimestamp() ? -1 : 1;
	}



}