<?php

/**
 * Convert the date from Croatian format to English format.
 * @param string|null $date The date in Croatian format (dd.mm.yyyy) or null.
 * @return string|null The date in English format (yyyy-mm-dd) or null.
 */
function convertDateTimeToEnglishFormat(?string $date): ?string
{
    if (empty($date)) {
        return null;
    }

    // Provjera je li pruženi datum u formatu yyyy (samo godina)
    if (preg_match('/^\d{4}$/', $date)) {
        // Ako je u formatu yyyy, vraćamo oblik 'Y-m-d H:i'
        $dateEng = $date . '-01-01 00:00';
        return $dateEng;
    }

    // Provjera je li pruženi datum u formatu Y-m-d (godina-mjesec-dan)
    if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) {
        // Ako je u formatu Y-m-d, dodajemo vrijeme '00:00'
        $dateEng = $date . ' 00:00';
        return $dateEng;
    }

    $dateHrv = strtotime($date);
    $dateEng = date('Y-m-d H:i', $dateHrv);
    return $dateEng;
}
function convertDateToEnglishFormat(?string $date): ?string
{
    if (empty($date)) {
        return null;
    }

    // Provjera je li pruženi datum u formatu yyyy (samo godina)
    if (preg_match('/^\d{4}$/', $date)) {
        // Ako je u formatu yyyy, vraćamo oblik 'Y-m-d H:i'
        $dateEng = $date . '-01-01';
        return $dateEng;
    }

    // Provjera je li pruženi datum u formatu Y-m-d (godina-mjesec-dan)
    if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) {
        // Ako je u formatu Y-m-d, dodajemo vrijeme '00:00'
        $dateEng = $date;
        return $dateEng;
    }

    $dateHrv = strtotime($date);
    $dateEng = date('Y-m-d', $dateHrv);
    return $dateEng;
}
