/**
 * JavaScript functionality for person edit form
 */
document.addEventListener('DOMContentLoaded', function() {
    // Toggle switch functionality for activity status
    const toggleSwitch = document.getElementById('vidljivost-toggle');
    const vidljivostInput = document.getElementById('vidljivost');
    
    if (toggleSwitch && vidljivostInput) {
        // Set initial state
        vidljivostInput.value = toggleSwitch.checked ? '1' : '0';
        
        // Update on change
        toggleSwitch.addEventListener('change', function() {
            vidljivostInput.value = this.checked ? '1' : '0';
        });
    }
    
    // Cancel button functionality - NEW CODE
    const cancelButton = document.getElementById('cancelButton');
    if (cancelButton) {
        cancelButton.addEventListener('click', function() {
            history.back();
        });
    }
    
    // Custom select styling could be enhanced here if needed
    const customSelects = document.querySelectorAll('.custom-select-wrapper select');
    if (customSelects.length > 0) {
        customSelects.forEach(select => {
            // Add any additional custom select functionality if needed
            select.addEventListener('change', function() {
                // For future enhancements
            });
        });
    }
});