/**
 * Tasks Module Configuration - SIMPLIFIED VERSION
 * Fiksna strategija bez auto-detection kompleksnosti
 */

// ==========================================
// TASKS MODULE CONFIGURATION
// ==========================================

const TASKS_CONFIG = {
  // Module basic info
  module: {
    name: 'tasks',
    title: 'Tasks Management',
    version: '1.0.0'
  },

  // Table configuration
  table: {
    selector: '#mojdatatables',
    pageLength: 20,
    lengthMenu: [[20, 50, 100, -1], [20, 50, 100, "All"]],
    scrollX: true,
    scrollCollapse: true,
    stateSave: true,
    strategy: 'client'  // FIKSNO: CLIENT-SIDE za tasks (mali dataset)
  },

  // Localization
  locale: {
    language: 'hr',
    fallback: 'en'
  },

  // Routes configuration
  routes: {
    fetchAjax: '/tasks/api/fetch-tasks',
    editRoute: '/task/edit',
    deleteRoute: '/task/api/delete'
  },

  // Features configuration
  features: {
    cascadingFilters: true,
    inlineEditing: true,
    columnVisibility: true,
    exportExcel: true,
    resetFilters: true,
    compactMode: true,
    rowStyling: true
  },

  // Debug settings
  debug: {
    enabled: false,
    logLevel: 'info'
  }
};

// ==========================================
// MODULE INITIALIZATION
// ==========================================

/**
 * Initialize Tasks module using the central initializer
 */
function initializeTasksModule() {
  if (typeof window.autoInitializeDataTablesModule === 'function') {
    window.autoInitializeDataTablesModule(TASKS_CONFIG);
  } else {
    console.error('DataTables module initializer not found. Make sure module-initializer.js is loaded first.');
  }
}

// Auto-initialize when DOM is ready
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initializeTasksModule);
} else {
  setTimeout(initializeTasksModule, 50);
}

// ==========================================
// EXPORT CONFIGURATION
// ==========================================

// Export configuration for external use
window.TASKS_CONFIG = TASKS_CONFIG;

// Export initialization function for manual use
window.initializeTasksModule = initializeTasksModule;