@errormodalreturn

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.editosoba'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1><?= isset($osoba->id) ? 'Edit Person' : 'Add New Person' ?></h1>
      <p>Enter person and workplace details</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('taskfte/list') ?>" class="action-button secondary">
        <i class="fas fa-arrow-left"></i> Back to List
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <h3 class="card-title">
        <i class="fas fa-user-edit"></i> Person Details
      </h3>
    </div>
    <div class="card-body">
      <form action="" method="post" class="modern-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
          <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <!-- Personal Details -->
        <div class="form-section">
          <h4 class="section-title">Personal Details</h4>
          
          <div class="form-grid">
            <div class="form-group">
              <label for="name">Full Name</label>
              <input type="text" 
                    class="form-control" 
                    id="name" 
                    name="osoba[name]" 
                    required 
                    value="<?= htmlspecialchars($osoba->name ?? ''); ?>"
                    placeholder="Enter full name">
              <small class="form-text">Full name of the person</small>
            </div>

            <div class="form-group">
              <label for="radnomjesto">Job Position</label>
              <div class="custom-select-wrapper">
                <select class="form-control" 
                      id="radnomjesto" 
                      name="osoba[radnomjesto]" 
                      required>
                  <option value="" disabled <?= empty($osoba->radnomjesto) ? 'selected' : '' ?>>Select Job Position</option>
                  <option value="Tehničar" <?= (isset($osoba->radnomjesto) && $osoba->radnomjesto == 'Tehničar') ? 'selected' : '' ?>>Tehničar</option>
                  <option value="Voditelj" <?= (isset($osoba->radnomjesto) && $osoba->radnomjesto == 'Voditelj') ? 'selected' : '' ?>>Voditelj</option>
                </select>
                <i class="fas fa-chevron-down select-arrow"></i>
              </div>
              <small class="form-text">Position the person holds</small>
            </div>

            <div class="form-group">
              <label for="tvrtka">Company</label>
              <div class="custom-select-wrapper">
                <select class="form-control" 
                      id="tvrtka" 
                      name="osoba[tvrtka]" 
                      required>
                  <option value="" disabled <?= empty($osoba->tvrtka) ? 'selected' : '' ?>>Select Company</option>
                  <option value="Optilink" <?= (isset($osoba->tvrtka) && $osoba->tvrtka == 'Optilink') ? 'selected' : '' ?>>Optilink</option>
                  <option value="Shinobi apps" <?= (isset($osoba->tvrtka) && $osoba->tvrtka == 'Shinobi apps') ? 'selected' : '' ?>>Shinobi apps</option>
                </select>
                <i class="fas fa-chevron-down select-arrow"></i>
              </div>
              <small class="form-text">Company where the person is employed</small>
            </div>
          </div>
        </div>
        
        <!-- Organizational Details -->
        <div class="form-section">
          <h4 class="section-title">Organizational Details</h4>
          
          <div class="form-grid">
            <div class="form-group">
              <label for="area">Area</label>
              <div class="custom-select-wrapper">
                <select class="form-control" 
                      id="area" 
                      name="osoba[area]" 
                      required>
                  <option value="" disabled <?= empty($osoba->area) ? 'selected' : '' ?>>Select Area</option>
                  <option value="" <?= (isset($osoba->area) && $osoba->area == '') ? 'selected' : '' ?>></option>
                  <option value="OS" <?= (isset($osoba->area) && $osoba->area == 'OS') ? 'selected' : '' ?>>OS</option>
                  <option value="VU" <?= (isset($osoba->area) && $osoba->area == 'VU') ? 'selected' : '' ?>>VU</option>
                </select>
                <i class="fas fa-chevron-down select-arrow"></i>
              </div>
              <small class="form-text">Person's work area</small>
            </div>

            <div class="form-group">
              <label for="orgjedinica">Organizational Unit</label>
              <div class="custom-select-wrapper">
                <select class="form-control" 
                      id="orgjedinica" 
                      name="osoba[orgjedinica]" 
                      required>
                  <option value="" disabled <?= empty($osoba->orgjedinica) ? 'selected' : '' ?>>Select Organizational Unit</option>
                  <option value="Izgradnja" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Izgradnja') ? 'selected' : '' ?>>Izgradnja</option>
                  <option value="Održavanje" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Održavanje') ? 'selected' : '' ?>>Održavanje</option>
                  <option value="Backoffice" <?= (isset($osoba->orgjedinica) && $osoba->orgjedinica == 'Backoffice') ? 'selected' : '' ?>>Backoffice</option>
                </select>
                <i class="fas fa-chevron-down select-arrow"></i>
              </div>
              <small class="form-text">Organizational unit to which the person belongs</small>
            </div>

            <div class="form-group">
              <label for="vidljivost">Activity Status</label>
              <div class="toggle-container">
                <input type="checkbox" id="vidljivost-toggle" class="toggle-switch" 
                      <?= (isset($osoba->vidljivost) && $osoba->vidljivost == 1) ? 'checked' : '' ?>>
                <label for="vidljivost-toggle" class="toggle-label">
                  <span class="toggle-inner"></span>
                  <span class="toggle-switch-label">
                    <span class="status-text active">Active</span>
                    <span class="status-text inactive">Inactive</span>
                  </span>
                </label>
                <input type="hidden" name="osoba[vidljivost]" id="vidljivost" 
                      value="<?= isset($osoba->vidljivost) ? $osoba->vidljivost : '1' ?>">
              </div>
              <small class="form-text">Status of the person in the system</small>
            </div>
          </div>
        </div>

        <div class="form-actions">
          <button type="button" class="form-button secondary" id="cancelButton">
            <i class="fas fa-times"></i> Cancel
          </button>
          <button type="submit" class="form-button primary" value="submit">
            <i class="fas fa-save"></i> Save
          </button>
        </div>
      </form>
    </div>
  </div>
</div>