<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.listosoba'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>People</h1>
      <p>Overview and management of people in the system</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('taskfte/edit') ?>" class="action-button primary">
        <i class="fas fa-user-plus"></i> Add New Person
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Export
      </button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-users"></i> List of People
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Search people...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>By Org. Unit:</label>
              <div class="filter-options" id="orgFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>By Company:</label>
              <div class="filter-options" id="companyFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>By Status:</label>
              <div class="filter-options">
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="status" data-value="1"> 
                  Active
                </label>
                <label class="filter-checkbox">
                  <input type="checkbox" data-filter="status" data-value="0"> 
                  Inactive
                </label>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="100">Actions</th>
            <th class="sortable">Person Name</th>
            <th class="sortable">Job Position</th>
            <th class="sortable">Company</th>
            <th class="sortable">Area</th>
            <th class="sortable">Organizational Unit</th>
            <th class="sortable">Status</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($osobe as $osoba): ?>
          <tr data-status="<?= htmlspecialchars($osoba->vidljivost ?? '0', ENT_QUOTES, 'UTF-8') ?>">
            <td>
              <div class="table-actions">
                <a href="<?= route('taskfte/edit') ?>/<?=$osoba->id?>" 
                   class="action-btn edit" title="Edit Person">
                  <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="action-btn delete" 
                        data-id="<?=$osoba->id?>" 
                        data-name="<?= htmlspecialchars($osoba->name ?? '', ENT_QUOTES, 'UTF-8') ?>"
                        title="Delete Person">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            </td>
            <td>
              <div class="person-name">
                <i class="fas fa-user person-icon"></i>
                <?= htmlspecialchars($osoba->name ?? '', ENT_QUOTES, 'UTF-8') ?>
              </div>
            </td>
            <td>
              <?= htmlspecialchars($osoba->radnomjesto ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <span class="company-badge">
                <?= htmlspecialchars($osoba->tvrtka ?? '', ENT_QUOTES, 'UTF-8') ?>
              </span>
            </td>
            <td>
              <?= htmlspecialchars($osoba->area ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <span class="org-badge">
                <?= htmlspecialchars($osoba->orgjedinica ?? '', ENT_QUOTES, 'UTF-8') ?>
              </span>
            </td>
            <td>
              <?php if(isset($osoba->vidljivost) && $osoba->vidljivost == 1): ?>
                <span class="status-badge status-active">Active</span>
              <?php else: ?>
                <span class="status-badge status-inactive">Inactive</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Data Export
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="" method="post" id="exportForm">

          @csrf
          
          <div class="form-group">
            <label for="file_type">Export Format</label>
            <select name="file_type"id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Export Data
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h3>Delete Confirmation</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <p>Are you sure you want to delete the person <strong id="deleteName"></strong>?</p>
      <p class="text-danger">This action cannot be undone.</p>
    </div>
    <div class="modal-footer">
      <form action="<?= route('taskfte/delete') ?>" method="post" id="deleteForm">

        @csrf
        
        <input type="hidden" name="id" id="deleteId" value="">
        <button type="button" class="form-button secondary modal-cancel">Cancel</button>
        <button type="submit" class="form-button danger">Delete</button>
      </form>
    </div>
  </div>
</div>