<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('amcharts'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('cms'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.admin'); ?>

<div class="admin-dashboard">
  <!-- Data container for charts -->
  <div id="task-charts-data" 
    data-status='<?= json_encode($statistics['tasksByStatus'] ?? []) ?>'
    data-type='<?= json_encode($statistics['tasksByType'] ?? []) ?>'
    data-monthly='<?= json_encode($statistics['monthlyTaskCounts'] ?? []) ?>'
    ></div>

  <div class="sidebar">
    <div class="sidebar-header">
      <h3>Tasks Admin</h3>
      <button id="mobile-toggle" class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </div>
    
    <div class="sidebar-content">
      <ul class="sidebar-menu">
        <li class="sidebar-item active">
          <a href="#" class="sidebar-link" data-target="taskTypes">
            <i class="fas fa-list-ul"></i>
            <span>Task Types</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('tasktype/list') ?>">
              <i class="fas fa-tasks"></i> Types - list & edit</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="taskUsers">
            <i class="fas fa-users"></i>
            <span>People</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('taskfte/list') ?>">
              <i class="fas fa-user-edit"></i> People - list & edit</a>
            </li>
          </ul>
        </li>
        
        <li class="sidebar-item">
          <a href="#" class="sidebar-link" data-target="taskExports">
            <i class="fas fa-file-export"></i>
            <span>Tasks</span>
          </a>
          <ul class="sidebar-submenu">
            <li><a href="<?= route('tasks/export') ?>">
              <i class="fas fa-file-excel"></i> Export tasks -> xlsx</a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>

  <div class="main-content">
    <div class="content-header">
      <h2>Task Management</h2>
      <p>Manage tasks, task types, and users</p>
    </div>

    <div class="content-body">
      <!-- Summary Cards -->
      <div class="dashboard-cards">
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-tasks"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['taskTypesCount'] ?? 0 ?></span>
            <span class="card-label">Task Types</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-users"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['usersCount'] ?? 0 ?></span>
            <span class="card-label">Users</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-clipboard-check"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['completedTasksCount'] ?? 0 ?></span>
            <span class="card-label">Completed Tasks</span>
          </div>
        </div>
        
        <div class="dashboard-card">
          <div class="card-icon">
            <i class="fas fa-spinner"></i>
          </div>
          <div class="card-data">
            <span class="card-value"><?= $statistics['inProgressTasksCount'] ?? 0 ?></span>
            <span class="card-label">Tasks in Progress</span>
          </div>
        </div>
      </div>
      
      <!-- Stats Cards Row -->
      <div class="stats-cards">
        <!-- Tasks By Status -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-pie"></i> Tasks by Status</h3>
          </div>
          <div class="stats-card-body">
            <canvas id="tasksByStatusChart"></canvas>
          </div>
        </div>

        <!-- Tasks By Type -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-pie"></i> Tasks by Type</h3>
          </div>
          <div class="stats-card-body">
            <canvas id="tasksByTypeChart"></canvas>
          </div>
        </div>

        <!-- Monthly Tasks -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-line"></i> Monthly Tasks</h3>
          </div>
          <div class="stats-card-body">
            <canvas id="monthlyTasksChart"></canvas>
          </div>
        </div>
      </div>

      <!-- Additional Stats Row -->
      <div class="stats-cards">
        <!-- Top Performers -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-trophy"></i> Top Performers</h3>
          </div>
          <div class="stats-card-body">
            <div class="top-performers-list">
              <?php if (isset($statistics['topPerformers']) && count($statistics['topPerformers']) > 0): ?>
                <?php foreach ($statistics['topPerformers'] as $index => $performer): ?>
                  <div class="performer-item">
                    <div class="performer-rank"><?= $index + 1 ?></div>
                    <div class="performer-info">
                      <span class="performer-name"><?= htmlspecialchars($performer['name']) ?></span>
                      <div class="performer-stats">
                        <span class="performer-tasks"><i class="fas fa-tasks"></i> <?= $performer['task_count'] ?> tasks</span>
                        <span class="performer-work"><i class="fas fa-euro-sign"></i> <?= number_format($performer['total_work'], 2) ?></span>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="empty-state">
                  <p>No performer data available</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Key Metrics -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-chart-bar"></i> Key Metrics</h3>
          </div>
          <div class="stats-card-body">
            <div class="metrics-grid">
              <div class="metric-item">
                <div class="metric-icon">
                  <i class="fas fa-euro-sign"></i>
                </div>
                <div class="metric-data">
                  <span class="metric-value"><?= number_format($statistics['totalRevenue'] ?? 0, 2) ?></span>
                  <span class="metric-label">Total Revenue</span>
                </div>
              </div>
              
              <div class="metric-item">
                <div class="metric-icon">
                  <i class="fas fa-clock"></i>
                </div>
                <div class="metric-data">
                  <span class="metric-value"><?= number_format($statistics['averageResolutionTime'] ?? 0, 1) ?> h</span>
                  <span class="metric-label">Avg. Resolution Time</span>
                </div>
              </div>
              
              <div class="metric-item">
                <div class="metric-icon">
                  <i class="fas fa-tasks"></i>
                </div>
                <div class="metric-data">
                  <span class="metric-value"><?= array_sum(array_column($statistics['tasksByStatus'] ?? [], 'count')) ?></span>
                  <span class="metric-label">Total Tasks</span>
                </div>
              </div>
              
              <div class="metric-item">
                <div class="metric-icon">
                  <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="metric-data">
                  <?php
                  $highPriorityCount = 0;
                  if (isset($statistics['tasksByPriority'])) {
                    foreach ($statistics['tasksByPriority'] as $priority) {
                      if ($priority['priority'] === 'High') {
                        $highPriorityCount = $priority['count'];
                        break;
                      }
                    }
                  }
                  ?>
                  <span class="metric-value"><?= $highPriorityCount ?></span>
                  <span class="metric-label">High Priority Tasks</span>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Recent Tasks -->
        <div class="stats-card">
          <div class="stats-card-header">
            <h3><i class="fas fa-history"></i> Recent Tasks</h3>
          </div>
          <div class="stats-card-body">
            <?php if (isset($statistics['recentTasks']) && count($statistics['recentTasks']) > 0): ?>
              <div class="recent-tasks-list">
                <?php foreach ($statistics['recentTasks'] as $task): ?>
                  <div class="recent-task-item">
                    <div class="task-type"><?= htmlspecialchars($task['ticket_type']) ?></div>
                    <div class="task-details">
                      <div class="task-address"><?= htmlspecialchars($task['ticket_address']) ?></div>
                      <div class="task-meta">
                        <span class="task-date"><?= (new DateTime($task['ticket_date']))->format('d.m.Y H:i') ?></span>
                        <span class="task-status <?= strtolower(str_replace(' ', '-', $task['ticket_vrsta'] ?? '')) ?>"><?= htmlspecialchars($task['ticket_vrsta'] ?? 'N/A') ?></span>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php else: ?>
              <div class="empty-state">
                <p>No recent tasks available</p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      
      <!-- Management Cards -->
      <div class="management-cards">
        <!-- Task Types Card -->
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-list-ul"></i> Task Types
            </h3>
            <div class="card-tools">
              <a href="<?= route('tasktype/list') ?>" class="action-button secondary">
                <i class="fas fa-eye"></i> View All
              </a>
            </div>
          </div>
          <div class="card-body">
            <div class="task-type-list">
              <div class="empty-state">
                <i class="fas fa-clipboard-list"></i>
                <p>Click "View All" to view and edit task types</p>
                <a href="<?= route('tasktype/list') ?>" class="action-button primary">
                  <i class="fas fa-plus"></i> Add New Type
                </a>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Users Card -->
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-users"></i> Users and People
            </h3>
            <div class="card-tools">
              <a href="<?= route('taskfte/list') ?>" class="action-button secondary">
                <i class="fas fa-eye"></i> View All
              </a>
            </div>
          </div>
          <div class="card-body">
            <div class="users-list">
              <div class="empty-state">
                <i class="fas fa-user-plus"></i>
                <p>Click "View All" to view and edit users</p>
                <a href="<?= route('taskfte/list') ?>" class="action-button primary">
                  <i class="fas fa-user-plus"></i> Add New User
                </a>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Export Card -->
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">
              <i class="fas fa-file-export"></i> Task Export
            </h3>
          </div>
          <div class="card-body">
            <div class="export-options">
              <div class="export-option">
                <div class="export-icon">
                  <i class="fas fa-file-excel"></i>
                </div>
                <div class="export-info">
                  <h4>Excel Export</h4>
                  <p>Export all tasks to Excel format for further analysis</p>
                </div>
                <a href="<?= route('tasks/export') ?>" class="export-button">
                  <i class="fas fa-download"></i>
                </a>
              </div>
              
              <div class="export-option">
                <div class="export-icon">
                  <i class="fas fa-file-csv"></i>
                </div>
                <div class="export-info">
                  <h4>CSV Export</h4>
                  <p>Export all tasks to CSV format for system integration</p>
                </div>
                <a href="#" class="export-button">
                  <i class="fas fa-download"></i>
                </a>
              </div>
              
              <div class="export-option">
                <div class="export-icon">
                  <i class="fas fa-print"></i>
                </div>
                <div class="export-info">
                  <h4>Print Export</h4>
                  <p>Prepare tasks for printing in a suitable format</p>
                </div>
                <a href="#" class="export-button">
                  <i class="fas fa-download"></i>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>