<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('flatpickr');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.edittasks');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.comments');?>

@errormodalreturn

<div class="task-container">

    <div class="task-header" data-task-id="<?= htmlspecialchars($zadatak->id ?? ''); ?>">
        <h2>
            <?php if (isset($zadatak->id)): ?>
                Edit Task #<?= htmlspecialchars($zadatak->id ?? '') ?>
            <?php else: ?>
                New Task
            <?php endif; ?>
        </h2>
    </div>

    <form method="post" class="task-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
            <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="task-content">

            <!-- Task info card -->
            <div class="task-card">
                <div class="task-card-header">
                    <h3><i class="fas fa-info-circle"></i> Basic Information</h3>
                    <span class="step-indicator">1/4</span>
                </div>

                <div class="task-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="ticket_type">Type*</label>
                            <select class="form-control" id="ticket_type" name="zadatak[ticket_type]" required>
                                <option value="<?= htmlspecialchars($zadatak->ticket_type ?? ''); ?>"><?= htmlspecialchars($zadatak->ticket_type ?? ''); ?></option>
                                <option>A1</option>
                                <option>HT</option>
                                <option>TMHR</option>
                            </select>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="ticket_number">FSW VOID/WWMS Number*</label> 
                            <input type="number" class="form-control" id="ticket_number" name="zadatak[ticket_number]" required value="<?= htmlspecialchars($zadatak->ticket_number ?? ''); ?>">
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="ticket_connumb">Connected Tasks</label> 
                            <input type="number" class="form-control" id="ticket_connumb" name="zadatak[ticket_connumb]" value="<?= htmlspecialchars($zadatak->ticket_connumb ?? ''); ?>">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="ticket_address">Address*</label> 
                            <input type="text" class="form-control" id="ticket_address" name="zadatak[ticket_address]" required value="<?= htmlspecialchars($zadatak->ticket_address ?? ''); ?>">
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label for="ticket_contact">Contact</label> 
                            <input type="text" class="form-control" id="ticket_contact" name="zadatak[ticket_contact]" value="<?= htmlspecialchars($zadatak->ticket_contact ?? ''); ?>">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="ticket_priority">Priority</label>
                            <select class="form-control" id="ticket_priority" name="zadatak[ticket_priority]">
                                <option value="<?= htmlspecialchars($zadatak->ticket_priority ?? ''); ?>"><?= htmlspecialchars($zadatak->ticket_priority ?? ''); ?></option>
                                <option>Low</option>
                                <option>Medium</option>
                                <option>High</option>
                            </select>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="ticket_arrdate_input">Scheduled Date</label>
                            <div class="input-group">
                                <input type="text" id="ticket_arrdate_input" class="form-control" data-input name="zadatak[ticket_arrdate]"
                                    value="<?= isset($zadatak->ticket_arrdate) && $zadatak->ticket_arrdate ? date('d-m-Y H:i', strtotime($zadatak->ticket_arrdate)) : '' ?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="ticket_work">Work (€)</label> 
                            <?php
                                $formattedRad = number_format($zadatak->ticket_work ?? 0, 2, ',', '.');
                            ?>
                            <input type="text" class="form-control" id="ticket_work" name="zadatak[ticket_work]" inputmode="numeric" pattern="[0-9,.]+" value="<?= $formattedRad ?>">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-8">
                            <label for="ticket_comment">Information</label> 
                            <textarea class="form-control" id="ticket_comment" name="zadatak[ticket_comment]" rows="4"><?= htmlspecialchars($zadatak->ticket_comment ?? ''); ?></textarea>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="ticket_sharelink">Sharelink</label> 
                            <textarea class="form-control" id="ticket_sharelink" name="zadatak[ticket_sharelink]" rows="4"><?= htmlspecialchars($zadatak->ticket_sharelink ?? ''); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Task status card -->
            <div class="task-card">
                <div class="task-card-header">
                    <h3><i class="fas fa-tasks"></i> Status Information</h3>
                    <span class="step-indicator">2/4</span>
                </div>

                <div class="task-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="ticket_taken_input">Task Taken</label>
                            <div class="input-group">
                                <input type="text" id="ticket_taken_input" class="form-control" data-input name="zadatak[ticket_taken]"
                                    value="<?=isset($zadatak->ticket_taken) && $zadatak->ticket_taken ? date('d-m-Y H:i',strtotime($zadatak->ticket_taken)) : ''?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label for="ticket_resolved_input">Task Resolved</label>
                            <div class="input-group">
                                <input type="text" id="ticket_resolved_input" class="form-control" data-input name="zadatak[ticket_resolved]"
                                    value="<?=isset($zadatak->ticket_resolved) && $zadatak->ticket_resolved ? date('d-m-Y H:i',strtotime($zadatak->ticket_resolved)) : ''?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="col-12">
                            <label>Task Type*</label>
                            <div class="custom-checkbox-container">
                                <?php foreach ($vrste as $vrsta):?>
                                    <?php if ($vrsta->orgjedinica=="Izgradnja"): ?>
                                        <?php 
                                            $isChecked = is_array($selected_vrste) && in_array($vrsta->id, $selected_vrste);
                                        ?>
                                        <div class="custom-checkbox">
                                            <input type="checkbox" id="vrsta_<?=$vrsta->id?>" name="vrsta[]" 
                                                <?= $isChecked ? 'checked' : '' ?> 
                                                value="<?=$vrsta->id?>">
                                            <label for="vrsta_<?=$vrsta->id?>"><?= htmlspecialchars($vrsta->name); ?></label>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Personnel card -->
            <div class="task-card">
                <div class="task-card-header">
                    <h3><i class="fas fa-user-friends"></i> Personnel</h3>
                    <span class="step-indicator">3/4</span>
                </div>

                <div class="task-card-body">
                    <div class="form-row">
                        <div class="col-12">
                            <label>Assign Technicians*</label>
                            <div class="custom-checkbox-container people-checkboxes">
                                <?php foreach ($osobe as $osoba):?>
                                    <?php if ($osoba->orgjedinica=="Izgradnja"): ?>
                                        <?php 
                                            $isChecked = is_array($selected_osobe) && in_array($osoba->id, $selected_osobe);
                                        ?>
                                        <div class="custom-checkbox person-checkbox">
                                            <input type="checkbox" id="osoba_<?=$osoba->id?>" name="osoba[]" 
                                                <?= $isChecked ? 'checked' : '' ?> 
                                                value="<?=$osoba->id?>">
                                            <label for="osoba_<?=$osoba->id?>">
                                                <span class="person-name"><?= htmlspecialchars($osoba->name); ?></span>
                                            </label>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Resources card -->
            <div class="task-card">
                <div class="task-card-header">
                    <h3><i class="fas fa-map-marker-alt"></i> Location & Resources</h3>
                    <span class="step-indicator">4/4</span>
                </div>

                <div class="task-card-body">
                    <?php if (!empty($zadatak->id)): ?>
                        <div class="map-container">
                            <iframe src="https://maps.google.com/maps?q=<?= htmlspecialchars($zadatak->ticket_address ?? ''); ?>&output=embed"></iframe>
                        </div>
                        
                        <?php if (!empty($zadatak->id)): ?>
                            <div class="form-row mt-3">
                                <div class="col-md-6 mb-2">
                                    <a class="btn btn-block btn-outline-primary" href="<?= route('zaobracun/index') ?>/<?=$zadatak->id ?>">
                                        <i class="fas fa-clipboard-list"></i> Work Performed
                                    </a>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <a class="btn btn-block btn-outline-success" href="<?= route('zagooglegeo/user') ?>/<?=$zadatak->id ?>">
                                        <i class="fas fa-map-pin"></i> Work Site Geolocation
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Map and additional resources will be available after saving the task.
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
        
        <div class="task-footer">
            <button type="submit" class="btn btn-primary btn-lg" name="btnSubmit">
                <i class="fas fa-save"></i> Save Task
            </button>
            <a href="<?= route('tasks/list') ?>" class="btn btn-outline-secondary btn-lg">
                <i class="fas fa-times"></i> Cancel
            </a>
        </div>

    </form>

    <?php if (!empty($zadatak->id)) { ?>
    
        <!-- Comments section for desktop -->
        <div class="task-card comments-card">
            <div class="task-card-header">
                <h3><i class="fas fa-comments"></i> Comments</h3>
                <button type="button" class="btn btn-sm btn-primary add-comment-btn">
                    <i class="fas fa-plus"></i> Add Comment
                </button>
            </div>

            <div class="task-card-body">
                <div class="comments-container"></div>
                <div class="text-center mt-2"><span id="comment_message"></span></div>
            </div>
        </div>

        <!-- Floating comments button for mobile -->
        <div class="floating-comments-btn">
            <button type="button" id="comments_floating_btn" class="btn btn-primary btn-circle">
                <i class="fas fa-comments"></i>
            </button>
            <span class="comments-count" id="comments_count">0</span>
        </div>
        
        <!-- Mobile comments overlay -->
        <div class="comments-overlay" id="comments_overlay">
            <div class="overlay-header">
                <h4><i class="fas fa-comments"></i> Comments</h4>
                <button type="button" class="overlay-close" id="close_comments_overlay">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <div class="overlay-body">
                <div class="comments-container"></div>
            </div>

            <div class="overlay-footer">
                <button type="button" class="btn btn-primary add-comment-btn">
                    <i class="fas fa-plus"></i> Add Comment
                </button>
            </div>
        </div>

        <!-- Comments Modal -->
        <div class="modal fade" id="commentModal" tabindex="-1" aria-labelledby="commentModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="commentModalLabel">
                            <i class="fas fa-comment"></i> 
                            <span id="comment-title">Add Comment</span>
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <form method="POST" id="comment_form">
                            <div class="form-group">
                                <textarea class="form-control" name="comment_content" id="comment_content" rows="4" placeholder="Type your comment here..."></textarea>
                            </div>
                            <input type="hidden" name="zadatakId" id="zadatakId" value="<?=$zadatak->id;?>" />
                            <input type="hidden" name="comment_id" id="comment_id" value="0" />
                            <input type="hidden" name="comment_name" id="comment_name" value="<?=$user->user_email;?>" />
                            <input type="hidden" name="date" id="date" value="<?= (new DateTime('now', new DateTimeZone(\baseKRIZAN\Config\Config::get('defaulttimezone'))))->format('Y-m-d H:i:s'); ?>" />
                            <div class="text-right">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                <button type="submit" name="submit" id="submit" class="btn btn-primary">
                                    <i class="fas fa-paper-plane"></i> Submit
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
    <?php } ?>
    
</div>