@errormodalreturn

<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.editvrsta'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1><?= isset($vrsta->id) ? 'Edit Task Type' : 'Add New Task Type' ?></h1>
      <p>Enter the required details for the task type</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('tasktype/list') ?>" class="action-button secondary">
        <i class="fas fa-arrow-left"></i> Back to List
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <h3 class="card-title">
        <i class="fas fa-edit"></i> Task Type Details
      </h3>
    </div>
    <div class="card-body">
      <form action="" method="post" class="modern-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
          <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="form-grid">
          <div class="form-group">
            <label for="name">Type Name</label>
            <input type="text" 
                  class="form-control" 
                  id="name" 
                  name="vrsta[name]" 
                  required 
                  value="<?= htmlspecialchars($vrsta->name ?? ''); ?>"
                  placeholder="Enter task type name">
            <small class="form-text">Name of the task type to be displayed in the system</small>
          </div>

          <div class="form-group">
            <label for="orgjedinica">Organizational Unit</label>
            <div class="custom-select-wrapper">
              <select class="form-control" 
                    id="orgjedinica" 
                    name="vrsta[orgjedinica]" 
                    required>
                <option value="" disabled <?= empty($vrsta->orgjedinica) ? 'selected' : '' ?>>Select Organizational Unit</option>
                <option value="Izgradnja" <?= (isset($vrsta->orgjedinica) && $vrsta->orgjedinica == 'Izgradnja') ? 'selected' : '' ?>>Izgradnja</option>
                <option value="Održavanje" <?= (isset($vrsta->orgjedinica) && $vrsta->orgjedinica == 'Održavanje') ? 'selected' : '' ?>>Održavanje</option>
              </select>
              <i class="fas fa-chevron-down select-arrow"></i>
            </div>
            <small class="form-text">Organizational unit to which this task type belongs</small>
          </div>
        </div>

        <div class="form-actions">
          <button type="button" class="form-button secondary" id="cancelButton">
            <i class="fas fa-times"></i> Cancel
          </button>
          <button type="submit" class="form-button primary" value="submit">
            <i class="fas fa-save"></i> Save
          </button>
        </div>
      </form>
    </div>
  </div>
</div>