<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.listvrsta'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>Task Types</h1>
      <p>Overview and management of task types</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('tasktype/edit') ?>" class="action-button primary">
        <i class="fas fa-plus"></i> Add New Type
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Export
      </button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-list-ul"></i> List of Task Types
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Search types...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>By Org. Unit:</label>
              <div class="filter-options" id="orgFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="120">Actions</th>
            <th class="sortable">Type</th>
            <th class="sortable">Organizational Unit</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($vrste as $vrsta): ?>
          <tr>
            <td>
              <div class="table-actions">
                <a href="<?= route('tasktype/edit') ?>/<?=$vrsta->id?>" 
                   class="action-btn edit" title="Edit Type">
                  <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="action-btn delete" 
                        data-id="<?=$vrsta->id?>" 
                        data-name="<?= htmlspecialchars($vrsta->name ?? '', ENT_QUOTES, 'UTF-8') ?>"
                        title="Delete Type">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            </td>
            <td>
              <?= htmlspecialchars($vrsta->name ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <span class="org-badge"><?= htmlspecialchars($vrsta->orgjedinica ?? '', ENT_QUOTES, 'UTF-8') ?></span>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Data Export
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="" method="post" id="exportForm">

          @csrf
          
          <div class="form-group">
            <label for="file_type">Export Format</label>
            <select name="file_type" id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Export Data
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h3>Delete Confirmation</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <p>Are you sure you want to delete the type <strong id="deleteName"></strong>?</p>
      <p class="text-danger">This action cannot be undone.</p>
    </div>
    <div class="modal-footer">
      <form action="<?= route('tasktype/delete') ?>" method="post" id="deleteForm">

        @csrf
        
        <input type="hidden" name="id" id="deleteId" value="">
        <button type="button" class="form-button secondary modal-cancel">Cancel</button>
        <button type="submit" class="form-button danger">Delete</button>
      </form>
    </div>
  </div>
</div>