<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('flatpickr');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('select2');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tasks.workperformed');?>

<div class="wp-container">
    <div class="wp-header">
        <h2>
            <i class="fas fa-clipboard-list"></i> Work Performed
            <small>Task #<?= htmlspecialchars($zadatak->id) ?></small>
        </h2>
        <div class="wp-task-info">
            <span><strong>Type:</strong> <?= htmlspecialchars($zadatak->ticket_type) ?></span>
            <span><strong>Address:</strong> <?= htmlspecialchars($zadatak->ticket_address) ?></span>
        </div>
    </div>

    <div class="wp-content">
        <div class="wp-card">
            <div class="wp-card-header">
                <h3><i class="fas fa-search"></i> Add New Work Item</h3>
            </div>
            <div class="wp-card-body">
                <form id="searchForm" class="search-form">
                    <input type="hidden" id="zadatak_id" value="<?= htmlspecialchars($zadatak->id) ?>">
                    <input type="hidden" id="zadatak_type" value="<?= htmlspecialchars($zadatak->ticket_type) ?>">
                    
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="category">Category</label>
                            <select class="form-control" id="category">
                                <option value="">All</option>
                                <option value="labor">Labor</option>
                                <option value="material">Material</option>
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="search_query">Search for work item</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="search_query" 
                                    placeholder="Type at least 3 characters to search..." autocomplete="off">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" id="clear_search">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div id="search_results" class="search-results"></div>
                    
                    <div id="selected_item_container" class="selected-item-container d-none">
                        <div class="selected-item">
                            <div class="item-details">
                                <h4 id="selected_description">Item Name</h4>
                                <div class="item-meta">
                                    <span id="selected_category" class="badge"></span>
                                    <span id="selected_price"></span>
                                </div>
                            </div>
                            <div class="quantity-container">
                                <label for="quantity">Quantity</label>
                                <div class="input-group">
                                    <button class="btn btn-outline-secondary" type="button" id="decrease_quantity">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" class="form-control" id="quantity" value="1" min="0.1" step="0.1">
                                    <button class="btn btn-outline-secondary" type="button" id="increase_quantity">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <span id="unit_label"></span>
                            </div>
                        </div>
                        <button type="button" class="btn btn-primary btn-block mt-3" id="add_item_btn">
                            <i class="fas fa-plus"></i> Add to Task
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="wp-card">
            <div class="wp-card-header">
                <h3><i class="fas fa-list"></i> Work Items</h3>
                <div class="summary-info">
                    <span>Total: <strong id="total_amount"><?= number_format($summary['total_amount'] ?? 0, 2, ',', '.') ?> €</strong></span>
                    <span>Items: <strong id="items_count"><?= $summary['items_count'] ?? 0 ?></strong></span>
                </div>
            </div>
            <div class="wp-card-body">
                <div id="work_items_container" class="work-items-container">
                    <?php if (empty($workItems)): ?>
                        <div class="no-items">
                            <i class="fas fa-clipboard-list"></i>
                            <p>No work items added yet. Use the search above to add work items.</p>
                        </div>
                    <?php else: ?>
                        <div class="work-items-list">
                            <?php foreach ($workItems as $item): ?>
                                <div class="work-item" data-id="<?= $item['id'] ?>">
                                    <div class="item-content">
                                        <div class="item-header">
                                            <h4><?= htmlspecialchars($item['description']) ?></h4>
                                            <div class="item-actions">
                                                <button type="button" class="btn btn-sm btn-outline-primary edit-item-btn">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button type="button" class="btn btn-sm btn-outline-danger delete-item-btn">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="item-details">
                                            <span class="badge badge-<?= $item['category'] === 'labor' ? 'primary' : 'success' ?>">
                                                <?= ucfirst($item['category']) ?>
                                            </span>
                                            <span><?= number_format($item['quantity'], 2, ',', '.') ?> <?= $item['unit'] ?></span>
                                            <span><?= number_format($item['price'], 2, ',', '.') ?> €</span>
                                            <span class="item-total"><?= number_format($item['total'], 2, ',', '.') ?> €</span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="wp-footer">
        <a href="<?= route('task/edit') ?>/<?= $zadatak->id ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left"></i> Back to Task
        </a>
    </div>
</div>

<!-- Edit Quantity Modal -->
<div class="modal fade" id="editItemModal" tabindex="-1" role="dialog" aria-labelledby="editItemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editItemModalLabel">Edit Quantity</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editItemForm">
                    <input type="hidden" id="edit_item_id">
                    <div class="form-group">
                        <label id="edit_item_description" class="font-weight-bold"></label>
                        <div class="quantity-container mt-3">
                            <label for="edit_quantity">Quantity</label>
                            <div class="input-group">
                                <button class="btn btn-outline-secondary" type="button" id="decrease_edit_quantity">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <input type="number" class="form-control" id="edit_quantity" min="0.1" step="0.1">
                                <button class="btn btn-outline-secondary" type="button" id="increase_edit_quantity">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                            <span id="edit_unit_label"></span>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="save_edit_btn">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteItemModal" tabindex="-1" role="dialog" aria-labelledby="deleteItemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteItemModalLabel">Confirm Deletion</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this work item?</p>
                <p id="delete_item_description" class="font-weight-bold"></p>
                <input type="hidden" id="delete_item_id">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirm_delete_btn">Delete</button>
            </div>
        </div>
    </div>
</div>