<?php
// ===============================================
// tasks_dependencies.php (FIXED)
// ===============================================

use baseKRIZAN\Services\Container;
use tasks\Controllers\Tasks;
use tasks\Controllers\Vrsta;
use tasks\Controllers\Osoba;
use tasks\Controllers\Mytasks;
use tasks\Controllers\Comments;
use tasks\Controllers\WorkPerformed;
use tasks\Models\DatabaseTableTasks;
use tasks\Models\WorkPerformedTable;
use baseKRIZAN\Database\DatabaseConnection;

return function(Container $container) {
    $logger = $container->get('logger');
    
    // Dohvatimo DatabaseConnection
    $dbConnection = DatabaseConnection::getInstance();
    
    if ($container->has('eventDispatcher')) {
        $dbConnection->setServices(
            $container->get('eventDispatcher'),
            $logger
        );
    }
    
    // Initialize tables using DatabaseConnection
    $zadatakVrsteTable = new DatabaseTableTasks($dbConnection, 'zadatak_vrsta', 'vrstaId');
    $zadatakOsobeTable = new DatabaseTableTasks($dbConnection, 'zadatak_osoba', 'osobaId');
    
    $zadatciTable = new DatabaseTableTasks(
        $dbConnection, 'zadatak', 'id', 'tasks\Entity\Tasks', 
        [$zadatakVrsteTable, $zadatakOsobeTable]
    );
    
    $vrsteTable = new DatabaseTableTasks(
        $dbConnection, 'zadatak_vrste', 'id', 'tasks\Entity\Vrsta', 
        [$zadatciTable, $zadatakVrsteTable]
    );
    
    $osobeTable = new DatabaseTableTasks(
        $dbConnection, 'zadatak_osobe', 'id', 'tasks\Entity\Osoba', 
        [$zadatciTable, $zadatakOsobeTable, $zadatakVrsteTable]
    );
    
    $zadatakCommentsTable = new DatabaseTableTasks($dbConnection, 'zadatak_comments', 'comment_id');

    // Register tables in container
    $container->addServices([
        'zadatciTable' => $zadatciTable,
        'vrsteTable' => $vrsteTable,
        'zadatakVrsteTable' => $zadatakVrsteTable,
        'osobeTable' => $osobeTable,
        'zadatakOsobeTable' => $zadatakOsobeTable,
        'zadatakCommentsTable' => $zadatakCommentsTable,
        
        // DODAJ DatabaseConnection kao service
        'tasksDatabaseConnection' => $dbConnection,
        
        'workPerformedTable' => function($container) {
            $dbConnection = DatabaseConnection::getInstance();
            return new WorkPerformedTable(
                $dbConnection,
                $container->get('logger')
            );
        },
    ]);

    // Register controllers in container (BEZ DatatablesMappingService)
    $container->addServices([
        'tasksController' => function($container) {
            return new Tasks(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('zadatciTable'),
                $container->get('vrsteTable'),
                $container->get('zadatakVrsteTable'),
                $container->get('osobeTable'),
                $container->get('zadatakOsobeTable'),
                $container->get('zadatakCommentsTable'),
                $container->get('validator'),
                $container->get('tasksDatabaseConnection'), // DODANO
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
        'vrstaController' => function($container) {
            return new Vrsta(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('vrsteTable'),
                $container->get('validator'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
        'osobaController' => function($container) {
            return new Osoba(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('osobeTable'),
                $container->get('validator'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
        'mytasksController' => function($container) {
            return new Mytasks(
                $container->get('korisniciTable'),
                $container->get('authentication'),  
                $container->get('zadatciTable'),
                $container->get('vrsteTable'),
                $container->get('zadatakVrsteTable'),
                $container->get('osobeTable'),
                $container->get('zadatakOsobeTable'),
                $container->get('zadatakCommentsTable'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        },
        'commentsController' => function($container) {
            return new Comments(
                $container->get('korisniciTable'),
                $container->get('zadatciTable'),
                $container->get('vrsteTable'),
                $container->get('zadatakVrsteTable'),
                $container->get('osobeTable'),
                $container->get('zadatakOsobeTable'),
                $container->get('zadatakCommentsTable'),
                $container->get('validator'),
                $container->get('logger')
            );
        },
        'workPerformedController' => function($container) {
            return new WorkPerformed(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('zadatciTable'),
                $container->get('workPerformedTable'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        }
    ]);

    return [];
};