<?php
// app/config/tasks_routes.php

/**
 * Tasks application routes configuration
 * 
 * @var \baseKRIZAN\Routing\RouteBuilder $builder
 * @var \baseKRIZAN\Services\Container $container
 */

// =============================================
// WEB RUTE - vraćaju HTML stranice
// =============================================

// Tehničar rute - osnovne zadaće (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_tasks_tehnicar
], function($builder) {
    // Task edit rute
    $builder->get('task/edit', ['tasksController', 'edit']);
    $builder->get('task/edit/{id:number}', ['tasksController', 'edit']);
    $builder->post('task/edit', ['tasksController', 'saveEdit']);
    $builder->post('task/edit/{id:number}', ['tasksController', 'saveEdit']);
    
    // Task list rute
    $builder->get('tasks/list', ['tasksController', 'list']);
    
    // My Tasks rute
    $builder->get('mytasks/my-tasks', ['mytasksController', 'mytasks']);

    // Work Performed routes
    $builder->get('zaobracun/index/{id:number}', ['workPerformedController', 'index']);
});

// Voditelj rute - naprednije funkcionalnosti (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_tasks_voditelj
], function($builder) {
    // Export i admin rute
    $builder->get('tasks/export', ['tasksController', 'export']);
    $builder->get('tasks/admin', ['tasksController', 'admin']);
    
    // Task Type rute
    $builder->get('tasktype/edit', ['vrstaController', 'edit']);
    $builder->get('tasktype/edit/{id:number}', ['vrstaController', 'edit']);
    $builder->post('tasktype/edit', ['vrstaController', 'saveEdit']);
    $builder->post('tasktype/edit/{id:number}', ['vrstaController', 'saveEdit']);
    $builder->get('tasktype/list', ['vrstaController', 'list']);
    $builder->post('tasktype/delete', ['vrstaController', 'delete']);
    
    // Task FTE rute
    $builder->get('taskfte/edit', ['osobaController', 'edit']);
    $builder->get('taskfte/edit/{id:number}', ['osobaController', 'edit']);
    $builder->post('taskfte/edit', ['osobaController', 'saveEdit']);
    $builder->post('taskfte/edit/{id:number}', ['osobaController', 'saveEdit']);
    $builder->get('taskfte/list', ['osobaController', 'list']);
    $builder->post('taskfte/delete', ['osobaController', 'delete']);
});

// =============================================
// API RUTE - vraćaju JSON podatke
// =============================================

// Tehničar API rute
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_tasks_tehnicar
], function($builder) {
    // Task data fetch
    $builder->post('tasks/api/fetch-tasks', ['tasksController', 'fetchtasks']);
    $builder->post('mytasks/api/fetch-mytasks', ['mytasksController', 'fetchmytasks']);
    
    // Comments API
    $builder->post('comments/api/add-comments', ['commentsController', 'addComments']);
    $builder->post('comments/api/fetch-comments', ['commentsController', 'fetchComments']);
    $builder->post('comments/api/fetch-replies', ['commentsController', 'fetchReplies']);

    // Work Performed routes
    $builder->post('zaobracun/api/search', ['workPerformedController', 'search']);
    $builder->post('zaobracun/api/add-item', ['workPerformedController', 'addItem']);
    $builder->post('zaobracun/api/update-item', ['workPerformedController', 'updateItem']);
    $builder->post('zaobracun/api/delete-item', ['workPerformedController', 'deleteItem']);
});

// Master API rute - najviša razina ovlasti
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // Delete API endpoints
    $builder->post('task/api/delete', ['tasksController', 'delete']);
});