/**
 * JavaScript for travel order edit form functionality
 */
$(function () {
    // Initialize date picker
    flatpickr("#datum", {
        dateFormat: "d-m-Y",
        locale: "hr",
        allowInput: true,
        disableMobile: true,
        appendTo: document.body,
        position: "auto"
    });
    
    // Initialize departure time picker
    flatpickr("#vrijeme_polaska", {
        enableTime: true,
        noCalendar: true,
        dateFormat: "H:i",
        time_24hr: true,
        locale: "hr",
        allowInput: true,
        disableMobile: true,
        appendTo: document.body,
        position: "auto"
    });
    
    // Initialize arrival time picker
    flatpickr("#vrijeme_dolaska", {
        enableTime: true,
        noCalendar: true,
        dateFormat: "H:i",
        time_24hr: true,
        locale: "hr",
        allowInput: true,
        disableMobile: true,
        appendTo: document.body,
        position: "auto"
    });
    
    // Make calendar/clock icons clickable
    $(".input-group-text").on("click", function() {
        $(this).closest(".input-group").find("input").focus();
    });
    
    // Auto-calculate distance traveled on odometer input
    $("#pocetno_stanje_brojila, #zavrsno_stanje_brojila").on("input", calculateDistance);
    
    // Auto-calculate total fuel cost on price or quantity change
    $("#gorivo_cijena, #gorivo_kolicina").on("input", calculateFuelCost);
    
    // Vehicle mapping data
    const vehicleData = {
        "OS-754-PN": {
            vehicle: "Caddy 1",
            chassis: "WV1ZZZ2KZJX032355"
        },
        "OS-755-PN": {
            vehicle: "Transporter",
            chassis: "WV1ZZZHZKH081339"
        },
        "OS-276-RD": {
            vehicle: "Caddy 2",
            chassis: "WV1ZZZ2KZKX120152"
        },
        "OS-277-RD": {
            vehicle: "Caddy 3",
            chassis: "WV1ZZZ2KZKX119486"
        }
    };
    
    // Auto-fill vehicle and chassis based on registration
    $("#registracija").on("change", function() {
        const selectedReg = $(this).val();
        
        if (selectedReg in vehicleData) {
            $("#vozilo").val(vehicleData[selectedReg].vehicle);
            $("#broj_sasije").val(vehicleData[selectedReg].chassis);
        } else {
            $("#vozilo").val("");
            $("#broj_sasije").val("");
        }
    });
    
    // Trigger registration change on page load if a value is selected
    if ($("#registracija").val()) {
        $("#registracija").trigger("change");
    }
});

/**
 * Calculate distance traveled based on odometer readings
 */
function calculateDistance() {
    const pocetno = parseInt($("#pocetno_stanje_brojila").val()) || 0;
    const zavrsno = parseInt($("#zavrsno_stanje_brojila").val()) || 0;
    
    if (pocetno > 0 && zavrsno > 0) {
        const razlika = zavrsno - pocetno;
        if (razlika >= 0) {
            $("#prijedeni_km").val(razlika);
        }
    }
}

/**
 * Calculate total fuel cost based on price and quantity
 * Updated to handle empty fields properly
 */
function calculateFuelCost() {
    const cijenaValue = $("#gorivo_cijena").val().trim();
    const kolicinaValue = $("#gorivo_kolicina").val().trim();
    
    // If either field is empty, clear the total cost field
    if (cijenaValue === '' || kolicinaValue === '') {
        $("#gorivo_uk_cijena").val('');
        return;
    }
    
    const cijena = parseFloat(cijenaValue.replace(',', '.')) || 0;
    const kolicina = parseFloat(kolicinaValue.replace(',', '.')) || 0;
    
    if (cijena > 0 && kolicina > 0) {
        const ukupno = cijena * kolicina;
        $("#gorivo_uk_cijena").val(ukupno.toFixed(2).replace('.', ','));
    } else {
        $("#gorivo_uk_cijena").val('');
    }
}