<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('flatpickr');?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('travelorders.edittravelorders');?>

@errormodalreturn

<div class="travel-order-container">
    <form method="post" class="travel-order-form">
        
        @csrf
        
        <?php if (isset($edit_token)): ?>
            <input type="hidden" name="edit_token" value="<?= htmlspecialchars($edit_token) ?>">
        <?php endif; ?>

        <div class="travel-order-header">
            <h2>
                <?php if (!empty($travelOrder->id)): ?>
                    Edit travel order #<?= htmlspecialchars($travelOrder->id) ?>
                <?php else: ?>
                    New travel order
                <?php endif; ?>
            </h2>
        </div>

        <div class="travel-order-content">
            <!-- Basic info card -->
            <div class="travel-order-card">
                <div class="travel-order-card-header">
                    <h3><i class="fas fa-info-circle"></i> Basic information</h3>
                    <span class="step-indicator">1/3</span>
                </div>
                <div class="travel-order-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="datum">Date*</label>
                            <div class="input-group">
                                <input type="text" id="datum" class="form-control" data-input name="travel_order[datum]" 
                                    required value="<?=isset($travelOrder->datum) && $travelOrder->datum ? date('d-m-Y',strtotime($travelOrder->datum)) : ''?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="vrijeme_polaska">Departure time*</label>
                            <div class="input-group">
                                <input type="text" id="vrijeme_polaska" class="form-control" data-input name="travel_order[vrijeme_polaska]" 
                                    required value="<?=isset($travelOrder->vrijeme_polaska) ? date('H:i',strtotime($travelOrder->vrijeme_polaska)) : ''?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-clock"></i></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="vrijeme_dolaska">Arrival time*</label>
                            <div class="input-group">
                                <input type="text" id="vrijeme_dolaska" class="form-control" data-input name="travel_order[vrijeme_dolaska]" 
                                    required value="<?=isset($travelOrder->vrijeme_dolaska) ? date('H:i',strtotime($travelOrder->vrijeme_dolaska)) : ''?>" />
                                <div class="input-group-append" data-toggle>
                                    <div class="input-group-text"><i class="fas fa-clock"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="vozac">Driver*</label> 
                            <input type="text" class="form-control" id="vozac" name="travel_order[vozac]" required 
                                value="<?= htmlspecialchars($travelOrder->vozac ?? ''); ?>">
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label for="pravac_kretanja">Direction of travel*</label> 
                            <input type="text" class="form-control" id="pravac_kretanja" name="travel_order[pravac_kretanja]" required 
                                value="<?= htmlspecialchars($travelOrder->pravac_kretanja ?? ''); ?>">
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Vehicle info card -->
            <div class="travel-order-card">
                <div class="travel-order-card-header">
                    <h3><i class="fas fa-car"></i> Vehicle information</h3>
                    <span class="step-indicator">2/3</span>
                </div>
                <div class="travel-order-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="registracija">Registration*</label> 
                            <select class="form-control" id="registracija" name="travel_order[registracija]" required>
                                <option value="">-- Select registration --</option>
                                <option value="OS-754-PN" <?= (isset($travelOrder->registracija) && $travelOrder->registracija == 'OS-754-PN') ? 'selected' : '' ?>>OS-754-PN</option>
                                <option value="OS-755-PN" <?= (isset($travelOrder->registracija) && $travelOrder->registracija == 'OS-755-PN') ? 'selected' : '' ?>>OS-755-PN</option>
                                <option value="OS-276-RD" <?= (isset($travelOrder->registracija) && $travelOrder->registracija == 'OS-276-RD') ? 'selected' : '' ?>>OS-276-RD</option>
                                <option value="OS-277-RD" <?= (isset($travelOrder->registracija) && $travelOrder->registracija == 'OS-277-RD') ? 'selected' : '' ?>>OS-277-RD</option>
                            </select>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="vozilo">Vehicle*</label> 
                            <input type="text" class="form-control" id="vozilo" name="travel_order[vozilo]" required 
                                value="<?= htmlspecialchars($travelOrder->vozilo ?? ''); ?>" readonly>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="broj_sasije">Chassis number*</label> 
                            <input type="text" class="form-control" id="broj_sasije" name="travel_order[broj_sasije]" required 
                                value="<?= htmlspecialchars($travelOrder->broj_sasije ?? ''); ?>" readonly>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="pocetno_stanje_brojila">Initial odometer reading*</label> 
                            <input type="number" class="form-control" id="pocetno_stanje_brojila" 
                                name="travel_order[pocetno_stanje_brojila]" required 
                                value="<?= htmlspecialchars($travelOrder->pocetno_stanje_brojila ?? ''); ?>">
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="zavrsno_stanje_brojila">Final odometer reading*</label> 
                            <input type="number" class="form-control" id="zavrsno_stanje_brojila" 
                                name="travel_order[zavrsno_stanje_brojila]" required 
                                value="<?= htmlspecialchars($travelOrder->zavrsno_stanje_brojila ?? ''); ?>">
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="prijedeni_km">Distance traveled</label> 
                            <input type="number" class="form-control" id="prijedeni_km" 
                                name="travel_order[prijedeni_km]" 
                                value="<?= htmlspecialchars($travelOrder->prijedeni_km ?? ''); ?>" readonly>
                            <small class="form-text text-muted">Calculated automatically</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Fuel info card -->
            <div class="travel-order-card">
                <div class="travel-order-card-header">
                    <h3><i class="fas fa-gas-pump"></i> Fuel information</h3>
                    <span class="step-indicator">3/3</span>
                </div>
                <div class="travel-order-card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="gorivo_cijena">Fuel price (€/L)</label> 
                            <?php
                                $formattedCijena = isset($travelOrder->gorivo_cijena) 
                                    ? number_format((float)$travelOrder->gorivo_cijena, 2, ',', '.') 
                                    : '';
                            ?>
                            <input type="text" class="form-control" id="gorivo_cijena" 
                                name="travel_order[gorivo_cijena]"
                                inputmode="numeric" pattern="[0-9,.]+"
                                value="<?= $formattedCijena ?>">
                            <small class="form-text text-muted">Optional - leave empty if no fuel purchased</small>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="gorivo_kolicina">Fuel quantity (L)</label> 
                            <?php
                                $formattedKolicina = isset($travelOrder->gorivo_kolicina) 
                                    ? number_format((float)$travelOrder->gorivo_kolicina, 2, ',', '.') 
                                    : '';
                            ?>
                            <input type="text" class="form-control" id="gorivo_kolicina" 
                                name="travel_order[gorivo_kolicina]"
                                inputmode="numeric" pattern="[0-9,.]+"
                                value="<?= $formattedKolicina ?>">
                            <small class="form-text text-muted">Optional - leave empty if no fuel purchased</small>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label for="gorivo_uk_cijena">Total fuel cost (€)</label> 
                            <?php
                                $formattedUkupno = isset($travelOrder->gorivo_uk_cijena) 
                                    ? number_format((float)$travelOrder->gorivo_uk_cijena, 2, ',', '.') 
                                    : '';
                            ?>
                            <input type="text" class="form-control" id="gorivo_uk_cijena" 
                                name="travel_order[gorivo_uk_cijena]"
                                inputmode="numeric" pattern="[0-9,.]+"
                                value="<?= $formattedUkupno ?>" readonly>
                            <small class="form-text text-muted">Calculated automatically</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group col-md-12">
                            <label for="napomena">Notes</label> 
                            <textarea class="form-control" id="napomena" name="travel_order[napomena]" rows="3"><?= htmlspecialchars($travelOrder->napomena ?? ''); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="travel-order-footer">
            <button type="submit" class="btn btn-primary btn-lg" name="btnSubmit">
                <i class="fas fa-save"></i> Save travel order
            </button>
            <a href="<?= route('travelorders/list') ?>" class="btn btn-outline-secondary btn-lg">
                <i class="fas fa-times"></i> Cancel
            </a>
        </div>
    </form>
</div>