<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('tables'); ?>
<?php \baseKRIZAN\Assets\ResourceLoader::loadResource('travelorders.listtravelorders'); ?>

<div class="content-container">
  <div class="page-header">
    <div class="header-content">
      <h1>Travel Orders</h1>
      <p>View and manage travel orders</p>
    </div>
    <div class="header-actions">
      <a href="<?= route('travelorders/edit') ?>" class="action-button primary">
        <i class="fas fa-plus"></i> Add new travel order
      </a>
      <button type="button" id="exportToggle" class="action-button secondary">
        <i class="fas fa-download"></i> Export
      </button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-list-ul"></i> Travel orders list
      </div>
      <div class="card-tools">
        <div class="search-container">
          <input type="text" id="dataSearch" placeholder="Search travel orders...">
          <i class="fas fa-search"></i>
        </div>
        <div class="filter-dropdown">
          <button class="filter-button">
            <i class="fas fa-filter"></i> Filter
          </button>
          <div class="filter-menu">
            <div class="filter-group">
              <label>By month:</label>
              <div class="filter-options" id="monthFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>By driver:</label>
              <div class="filter-options" id="driverFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>By vehicle:</label>
              <div class="filter-options" id="vehicleFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
            <div class="filter-group">
              <label>By registration:</label>
              <div class="filter-options" id="registrationFilter">
                <!-- Will be populated by JavaScript -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="table-responsive">
      <table id="dataTable" class="data-table">
        <thead>
          <tr>
            <th width="120">Actions</th>
            <th class="sortable">Date</th>
            <th class="sortable">Driver</th>
            <th class="sortable">Vehicle</th>
            <th class="sortable">Registration</th>
            <th class="sortable">Direction</th>
            <th class="sortable">Distance (km)</th>
            <th class="sortable">Fuel (€)</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($travelOrders as $nalog): ?>
          <tr>
            <td>
              <div class="table-actions">
                <a href="<?= route('travelorders/edit') ?>/<?=$nalog->id?>" 
                   class="action-btn edit" title="Edit travel order">
                  <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="action-btn delete" 
                        data-id="<?=$nalog->id?>" 
                        data-name="<?= htmlspecialchars($nalog->vozac . ' - ' . date('d.m.Y', strtotime($nalog->datum)), ENT_QUOTES, 'UTF-8') ?>"
                        title="Delete travel order">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            </td>
            <td>
              <?= htmlspecialchars(date('d.m.Y', strtotime($nalog->datum)), ENT_QUOTES, 'UTF-8') ?>
              <small class="text-muted d-block"><?= date('H:i', strtotime($nalog->vrijeme_polaska)) ?> - <?= date('H:i', strtotime($nalog->vrijeme_dolaska)) ?></small>
            </td>
            <td class="driver-name">
              <?= htmlspecialchars($nalog->vozac ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <span class="vehicle-badge"><?= htmlspecialchars($nalog->vozilo ?? '', ENT_QUOTES, 'UTF-8') ?></span>
            </td>
            <td>
              <?= htmlspecialchars($nalog->registracija ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <?= htmlspecialchars($nalog->pravac_kretanja ?? '', ENT_QUOTES, 'UTF-8') ?>
            </td>
            <td>
              <span class="distance-display">
                <?= htmlspecialchars($nalog->prijedeni_km ?? '0', ENT_QUOTES, 'UTF-8') ?> km
              </span>
            </td>
            <td>
              <span class="cost-display">
                <?= htmlspecialchars(number_format((float)$nalog->gorivo_uk_cijena, 2, ',', '.'), ENT_QUOTES, 'UTF-8') ?> €
              </span>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Export Panel -->
  <div id="exportPanel" class="export-panel">
    <div class="card">
      <div class="card-header">
        <div class="card-title">
          <i class="fas fa-file-export"></i> Export data
        </div>
        <button id="closeExport" class="close-btn">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="card-body">
        <form action="<?= route('travelorders/export') ?>" method="post" id="exportForm">
          @csrf
          
          <div class="form-group">
            <label for="file_type">Export format</label>
            <select name="file_type" id="file_type" class="form-control">
              <option value="Xlsx">Excel (XLSX)</option>
              <option value="Csv">CSV</option>
            </select>
          </div>
          
          <div class="form-actions">
            <button type="submit" name="export" value="Export" class="form-button primary">
              <i class="fas fa-download"></i> Export filtered data
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h3>Delete confirmation</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <p>Are you sure you want to delete travel order <strong id="deleteName"></strong>?</p>
      <p class="text-danger">This action cannot be undone.</p>
    </div>
    <div class="modal-footer">
      <form action="<?= route('travelorders/api/delete') ?>" method="post" id="deleteForm">
        @csrf
        
        <input type="hidden" name="id" id="deleteId" value="">
        <button type="button" class="form-button secondary modal-cancel">Cancel</button>
        <button type="submit" class="form-button danger">Delete</button>
      </form>
    </div>
  </div>
</div>