<?php

use baseKRIZAN\Services\Container;
use travelorders\Controllers\TravelOrders;
use travelorders\Models\DatabaseTableTravelOrders;
use baseKRIZAN\Database\DatabaseConnection;

return function(Container $container) {
    // Get base dependencies from container
    $logger = $container->get('logger');
    
    // Get DatabaseConnection instance
    $dbConnection = DatabaseConnection::getInstance();
    
    // Set services on DatabaseConnection if eventDispatcher exists
    if ($container->has('eventDispatcher')) {
        $dbConnection->setServices(
            $container->get('eventDispatcher'),
            $logger
        );
    }
    
    // Initialize table using DatabaseConnection
    $travelOrdersTable = new DatabaseTableTravelOrders(
        $dbConnection, 'putni_nalozi', 'id'
    );
    
    // Register tables in container
    $container->addServices([
        'travelOrdersTable' => $travelOrdersTable
    ]);
    
    // No additional services needed

    // Register controllers in container
    $container->addServices([
        'travelOrdersController' => function($container) {
            return new TravelOrders(
                $container->get('korisniciTable'),
                $container->get('authentication'),
                $container->get('travelOrdersTable'),
                $container->get('validator'),
                $container->get('logger'),
                $container->get('sessionManager')
            );
        }
    ]);

    // Return empty array as we've registered services directly in container
    return [];
};