<?php
// app/config/travelorders_routes.php

/**
 * Putni nalozi application routes configuration
 * 
 * @var \baseKRIZAN\Routing\RouteBuilder $builder
 * @var \baseKRIZAN\Services\Container $container
 */

// =============================================
// WEB RUTE - vraćaju HTML stranice
// =============================================

// Tehničar rute - osnovne zadaće (web UI)
$builder->group([
    'middleware' => 'web',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_tasks_tehnicar
], function($builder) {
    // Putni nalog edit rute
    $builder->get('travelorders/edit', ['travelOrdersController', 'edit']);
    $builder->get('travelorders/edit/{id:number}', ['travelOrdersController', 'edit']);
    $builder->post('travelorders/edit', ['travelOrdersController', 'saveEdit']);
    $builder->post('travelorders/edit/{id:number}', ['travelOrdersController', 'saveEdit']);
    
    // Putni nalog list rute
    $builder->get('travelorders/list', ['travelOrdersController', 'list']);
    
    // Export ruta - dodana
    $builder->post('travelorders/export', ['travelOrdersController', 'export']);
});

// =============================================
// API RUTE - vraćaju JSON podatke
// =============================================

// Master API rute - najviša razina ovlasti
$builder->group([
    'middleware' => 'api',
    'auth' => true,
    'permission' => \Models\Entity\Korisnik::KORISNIK_MASTER
], function($builder) {
    // Delete API endpoints
    $builder->post('travelorders/api/delete', ['travelOrdersController', 'delete']);
});