/**
 * LUKA Dashboard Index JavaScript
 */
document.addEventListener('DOMContentLoaded', function() {
  // Mobile sidebar toggle functionality
  const sidebar = document.querySelector('.luka-sidebar');
  const mainContent = document.querySelector('.luka-main');
  
  // Create mobile toggle button in the header instead of as a floating button
  if (!document.querySelector('.luka-mobile-toggle')) {
      const headerElement = document.querySelector('.luka-header');
      
      if (headerElement) {
          // Create the toggle button
          const mobileToggle = document.createElement('button');
          mobileToggle.className = 'luka-mobile-toggle';
          mobileToggle.innerHTML = '<i class="fas fa-bars"></i>';
          
          // Insert at the beginning of the header
          headerElement.insertBefore(mobileToggle, headerElement.firstChild);
          
          // Add click event
          mobileToggle.addEventListener('click', function(e) {
              e.stopPropagation(); // Prevent document click from firing immediately
              sidebar.classList.toggle('show');
              
              // Change icon based on state
              const icon = this.querySelector('i');
              if (sidebar.classList.contains('show')) {
                  icon.className = 'fas fa-times';
                  document.body.classList.add('sidebar-open');
              } else {
                  icon.className = 'fas fa-bars';
                  document.body.classList.remove('sidebar-open');
              }
          });
      }
  }
  
  // Close sidebar when clicking outside on mobile
  document.addEventListener('click', function(event) {
      const isClickInsideSidebar = sidebar.contains(event.target);
      const isClickOnMobileToggle = event.target.closest('.luka-mobile-toggle');
      
      if (!isClickInsideSidebar && !isClickOnMobileToggle && sidebar.classList.contains('show')) {
          sidebar.classList.remove('show');
          document.body.classList.remove('sidebar-open');
          
          const icon = document.querySelector('.luka-mobile-toggle i');
          if (icon) {
              icon.className = 'fas fa-bars';
          }
      }
  });
  
  // Handle window resize - automatically close sidebar on larger screens
  window.addEventListener('resize', function() {
      if (window.innerWidth > 992 && sidebar.classList.contains('show')) {
          sidebar.classList.remove('show');
          document.body.classList.remove('sidebar-open');
          
          const icon = document.querySelector('.luka-mobile-toggle i');
          if (icon) {
              icon.className = 'fas fa-bars';
          }
      }
  });
  
  // Update time display
  function updateTimeDisplay() {
      const timeDisplay = document.querySelector('.time-display');
      if (timeDisplay) {
          const now = new Date();
          timeDisplay.textContent = now.toLocaleString();
      }
  }
  
  // Initial time update
  updateTimeDisplay();
  
  // Update time every minute
  setInterval(updateTimeDisplay, 60000);
});
//# sourceMappingURL=luka_index.188f8670.js.map