/**
 * Admin Dashboard JavaScript
 * Handles sidebar functionality
 */
document.addEventListener('DOMContentLoaded', function() {
  // Elements
  const sidebar = document.querySelector('.sidebar');
  const sidebarItems = document.querySelectorAll('.sidebar-item');
  const mobileToggle = document.getElementById('mobile-toggle');
  
  // Initialize sidebar only - table functionality dolazi iz table.js
  initSidebar();
  
  // Listen for theme changes
  document.addEventListener('themechange', function(event) {
    const theme = event.detail.theme;
    console.log('Theme changed to:', theme);
    // Any theme-specific adjustments can go here
  });
  
  /**
   * Initialize sidebar functionality
   */
  function initSidebar() {
    // Mobile toggle for sidebar
    if (mobileToggle) {
      mobileToggle.addEventListener('click', function() {
        sidebar.classList.toggle('open');
        
        // Change icon based on state
        const icon = mobileToggle.querySelector('i');
        if (sidebar.classList.contains('open')) {
          icon.classList.remove('fa-bars');
          icon.classList.add('fa-times');
        } else {
          icon.classList.remove('fa-times');
          icon.classList.add('fa-bars');
        }
      });
    }
    
    // Sidebar menu item click handlers
    sidebarItems.forEach(item => {
      const link = item.querySelector('.sidebar-link');
      
      link.addEventListener('click', function(e) {
        e.preventDefault();
        
        // Toggle active state on click
        const wasActive = item.classList.contains('active');
        
        // If we're on mobile, don't close the sidebar when toggling items
        const isMobile = window.innerWidth <= 768;
        
        // First, check if we should close other items
        if (!e.ctrlKey) { // Allow keeping multiple items open with Ctrl key
          sidebarItems.forEach(i => {
            if (i !== item) { // Don't touch the clicked item yet
              i.classList.remove('active');
            }
          });
        }
        
        // Toggle the clicked item
        if (wasActive) {
          item.classList.remove('active');
        } else {
          item.classList.add('active');
        }
        
        // Prevent closing sidebar on mobile when clicking items
        // You may want to close on actual submenu link clicks instead
        e.stopPropagation();
      });
    });
    
    // Handle clicks on submenu links - only these should navigate
    const submenuLinks = document.querySelectorAll('.sidebar-submenu li a');
    submenuLinks.forEach(link => {
      link.addEventListener('click', function(e) {
        // Allow normal navigation for these links
        // If we're on mobile, close the sidebar after clicking a submenu link
        if (window.innerWidth <= 768) {
          setTimeout(() => {
            sidebar.classList.remove('open');
            if (mobileToggle) {
              const icon = mobileToggle.querySelector('i');
              icon.classList.remove('fa-times');
              icon.classList.add('fa-bars');
            }
          }, 300);
        }
      });
    });
    
    // Set initial active state
    if (sidebarItems.length > 0 && !document.querySelector('.sidebar-item.active')) {
      sidebarItems[0].classList.add('active');
    }
  }
});
//# sourceMappingURL=cms.c10c1ded.js.map