// Unaprijeđeni script za error stranice

document.addEventListener('DOMContentLoaded', function() {
  // Dodajemo zvjezdice u pozadinu
  createStarryBackground();
  
  // Poboljšani efekt za content
  enhanceContent();
  
  // Poboljšani efekt za linkove
  enhanceLinks();
  
  // Dodajemo event listener za "go back" link
  setupGoBackLink();
  
  // Slušaj za promjene teme
  document.addEventListener('themechange', function(event) {
    // Osvježi boje neuralne mreže kada se promijeni tema
    console.log('Tema se promijenila, osvježavam prikaz');
  });
});

/**
 * Postavlja event listenere za link za povratak
 */
function setupGoBackLink() {
  const goBackLinks = document.querySelectorAll('.go-back-link');
  
  goBackLinks.forEach(link => {
    link.addEventListener('click', function(event) {
      event.preventDefault();
      goBack();
    });
    
    // Dodajemo klasu za stiliziranje
    link.classList.add('btn-back');
    link.innerHTML = '<i class="fas fa-arrow-left"></i> Go Back';
  });
}

/**
 * Stvara pozadinu sa zvjezdicama
 */
function createStarryBackground() {
  const hero = document.querySelector('.hero');
  if (!hero) return;
  
  // Dodaj gradijent u pozadini
  const gradientBg = document.createElement('div');
  gradientBg.className = 'gradient-bg';
  hero.appendChild(gradientBg);
  
  // Dodaj zvjezdice
  for (let i = 0; i < 50; i++) {
    const star = document.createElement('div');
    star.className = 'star';
    
    // Nasumična veličina
    const size = Math.random() * 3 + 1;
    star.style.width = `${size}px`;
    star.style.height = `${size}px`;
    
    // Nasumična pozicija
    star.style.left = `${Math.random() * 100}%`;
    star.style.top = `${Math.random() * 100}%`;
    
    // Nasumično kašnjenje animacije
    star.style.animationDelay = `${Math.random() * 4}s`;
    
    hero.appendChild(star);
  }
}

/**
 * Poboljšava izgled content box-a
 */
function enhanceContent() {
  const content = document.querySelector('.home-content');
  if (!content) return;
  
  // Dodaj efekt "typing" za output paragrafe
  const outputs = content.querySelectorAll('.output');
  if (outputs.length) {
    outputs.forEach((output, index) => {
      output.style.setProperty('--delay', index + 1);
    });
  }
  
  // Posebno animiraj countdown ako postoji
  const countdown = document.getElementById('countdown');
  if (countdown) {
    // Već ima CSS animaciju
  }
}

/**
 * Poboljšava interakciju linkova
 */
function enhanceLinks() {
  const links = document.querySelectorAll('.home-content a');
  
  links.forEach(link => {
    // Dodaj efekt za hover
    link.addEventListener('mouseenter', function() {
      this.style.color = 'var(--accent-secondary)';
    });
    
    link.addEventListener('mouseleave', function() {
      this.style.color = '';
    });
  });
}

/**
 * Funkcija za povratak nazad
 */
function goBack() {
  window.history.back();
}
//# sourceMappingURL=error.c26c2538.js.map