/**
 * Naplata Module Configuration - SIMPLIFIED VERSION
 * Fiksna strategija bez auto-detection kompleksnosti
 */

// ==========================================
// NAPLATA MODULE CONFIGURATION
// ==========================================

const NAPLATA_CONFIG = {
  // Module basic info
  module: {
    name: 'naplata',
    title: 'Naplata Management',
    version: '1.0.0'
  },

  // Table configuration
  table: {
    selector: '#mojdatatables',
    pageLength: 20,
    lengthMenu: [[20, 50, 100, -1], [20, 50, 100, "All"]],
    scrollX: true,
    scrollCollapse: true,
    stateSave: true,
    defaultOrder: [[1, 'asc']], // Sort by Tvrtka
    strategy: 'client'  // FIKSNO: CLIENT-SIDE za naplata (mali dataset)
  },

  // Localization
  locale: {
    language: 'hr',
    fallback: 'en'
  },

  // Routes configuration
  routes: {
    fetchAjax: '/naplata/api/fetch-naplata',
    editRoute: '/naplata/edit',
    deleteRoute: '/naplata/api/delete'
  },

  // Features configuration
  features: {
    cascadingFilters: true,
    inlineEditing: true,
    columnVisibility: true,
    exportExcel: true,
    resetFilters: true,
    compactMode: true,
    rowStyling: true
  },

  // Debug settings
  debug: {
    enabled: false,
    logLevel: 'info'
  }
};

// ==========================================
// MODULE INITIALIZATION
// ==========================================

/**
 * Initialize Naplata module using the central initializer
 */
function initializeNaplataModule() {
  if (typeof window.autoInitializeDataTablesModule === 'function') {
    window.autoInitializeDataTablesModule(NAPLATA_CONFIG);
  } else {
    console.error('DataTables module initializer not found. Make sure module-initializer.js is loaded first.');
  }
}

// Auto-initialize when DOM is ready
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initializeNaplataModule);
} else {
  setTimeout(initializeNaplataModule, 50);
}

// ==========================================
// EXPORT CONFIGURATION
// ==========================================

// Export configuration for external use
window.NAPLATA_CONFIG = NAPLATA_CONFIG;

// Export initialization function for manual use
window.initializeNaplataModule = initializeNaplataModule;
//# sourceMappingURL=naplata_listssp.e3e4fd2e.js.map