/**
 * Rashodi Module Configuration - SIMPLIFIED VERSION
 * Fiksna strategija bez auto-detection kompleksnosti
 */

// ==========================================
// RASHODI MODULE CONFIGURATION
// ==========================================

const RASHODI_CONFIG = {
  // Module basic info
  module: {
    name: 'rashodi',
    title: 'Rashodi Management',
    version: '1.0.0'
  },

  // Table configuration - RAZLIČIT SELECTOR!
  table: {
    selector: '#rashodidatatables', // RASHODI koristi drugi selector!
    pageLength: 20,
    lengthMenu: [[20, 50, 100, -1], [20, 50, 100, "All"]],
    scrollX: true,
    scrollCollapse: true,
    stateSave: true,
    defaultOrder: [[1, 'desc']], // Sort by Period descending
    strategy: 'client'  // FIKSNO: CLIENT-SIDE za rashodi (mali dataset)
  },

  // Localization
  locale: {
    language: 'hr',
    fallback: 'en'
  },

  // Routes configuration
  routes: {
    fetchAjax: '/rashodi/api/fetch-rashodi',
    editRoute: '/rashodi/edit',
    deleteRoute: '/rashodi/api/delete'
  },

  // Features configuration
  features: {
    cascadingFilters: true,
    inlineEditing: true,
    columnVisibility: true,
    exportExcel: true,
    resetFilters: true,
    compactMode: true,
    rowStyling: true
  },

  // Debug settings
  debug: {
    enabled: false,
    logLevel: 'info'
  }
};

// ==========================================
// MODULE INITIALIZATION
// ==========================================

/**
 * Initialize Rashodi module using the central initializer
 */
function initializeRashodiModule() {
  if (typeof window.autoInitializeDataTablesModule === 'function') {
    window.autoInitializeDataTablesModule(RASHODI_CONFIG);
  } else {
    console.error('DataTables module initializer not found. Make sure module-initializer.js is loaded first.');
  }
}

// Auto-initialize when DOM is ready
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initializeRashodiModule);
} else {
  setTimeout(initializeRashodiModule, 50);
}

// ==========================================
// EXPORT CONFIGURATION
// ==========================================

// Export configuration for external use
window.RASHODI_CONFIG = RASHODI_CONFIG;

// Export initialization function for manual use
window.initializeRashodiModule = initializeRashodiModule;
//# sourceMappingURL=rashodi_listssp.8e0b1e5b.js.map