/**
 * OIB Validator
 * Checks if an OIB already exists in the database
 */

// Hardcoded route
const publicUrl = JSON.parse(document.getElementById('app-config').textContent).paths.app_url;
const checkOib = `${publicUrl}/sales/api/check-oib`;

// Get sale ID from form header data attribute
const saleId = $('.form-header').data('sale-id') || '';

$(document).ready(function() {
    // Glavno OIB polje
    const $oibInput = $('#sale_oib');
    const $oibWarning = $('#oib-warning');
    const $oibWarningText = $('#oib-warning-text');

    // OIB prijenos vlasništva polje
    const $oibPrijenosVlInput = $('#sale_oib_prijenosvl');
    const $oibPrijenosVlWarning = $('#oib-prijenosvl-warning');
    const $oibPrijenosVlWarningText = $('#oib-prijenosvl-warning-text');

    let timeoutId;

    // Function to check OIB
    function checkOibExists(oib, currentId, warningElement, warningTextElement) {
        const formData = new FormData();
        formData.append('oib', oib);
        if(currentId) {
            formData.append('currentId', currentId);
        }

        $.ajax({
            url: checkOib,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(data) {
                if (data.exists) {
                    warningElement.show();
                    warningTextElement.show();
                } else {
                    warningElement.hide();
                    warningTextElement.hide();
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error('Error checking OIB:', textStatus, errorThrown);
                // Hide warnings on error to prevent false positives
                warningElement.hide();
                warningTextElement.hide();
            }
        });
    }

    // Initial check on page load if OIB exists for main OIB field
    const initialOib = $oibInput.val();
    if (initialOib && initialOib.length === 11) {
        checkOibExists(initialOib, saleId, $oibWarning, $oibWarningText);
    }

    // Initial check on page load if OIB exists for prijenos vlasništva field
    const initialOibPrijenosVl = $oibPrijenosVlInput.val();
    if (initialOibPrijenosVl && initialOibPrijenosVl.length === 11) {
        checkOibExists(initialOibPrijenosVl, saleId, $oibPrijenosVlWarning, $oibPrijenosVlWarningText);
    }

    // Check on input change for main OIB field
    $oibInput.on('input', function() {
        const oib = $(this).val();

        // Clear previous timeout
        if (timeoutId) {
            clearTimeout(timeoutId);
        }

        // Only check if OIB is complete (11 digits)
        if (oib.length === 11) {
            timeoutId = setTimeout(() => {
                checkOibExists(oib, saleId, $oibWarning, $oibWarningText);
            }, 300);
        } else {
            $oibWarning.hide();
            $oibWarningText.hide();
        }
    });

    // Check on input change for prijenos vlasništva OIB field
    $oibPrijenosVlInput.on('input', function() {
        const oib = $(this).val();

        // Clear previous timeout
        if (timeoutId) {
            clearTimeout(timeoutId);
        }

        // Only check if OIB is complete (11 digits)
        if (oib.length === 11) {
            timeoutId = setTimeout(() => {
                checkOibExists(oib, saleId, $oibPrijenosVlWarning, $oibPrijenosVlWarningText);
            }, 300);
        } else {
            $oibPrijenosVlWarning.hide();
            $oibPrijenosVlWarningText.hide();
        }
    });
});
//# sourceMappingURL=check_oib.dc762b83.js.map