/**
 * Sales Module Configuration - SIMPLIFIED VERSION
 * Fiksna strategija bez auto-detection kompleksnosti
 */

// ==========================================
// SALES MODULE CONFIGURATION
// ==========================================

const SALES_CONFIG = {
  // Module basic info
  module: {
    name: 'sales',
    title: 'Sales Management',
    version: '1.0.0'
  },

  // Table configuration
  table: {
    selector: '#mojdatatables',
    pageLength: 20,
    lengthMenu: [[20, 50, 100, -1], [20, 50, 100, "All"]],
    scrollX: true,
    scrollCollapse: true,
    stateSave: true,
    strategy: 'server'  // FIKSNO: SERVER-SIDE za sales (veliki dataset)
  },

  // Localization
  locale: {
    language: 'hr',
    fallback: 'en'
  },

  // Routes configuration
  routes: {
    fetchAjax: '/sales/api/fetch-sales',
    editRoute: '/sale/edit',
    deleteRoute: '/sale/api/delete'
  },

  // Features configuration
  features: {
    cascadingFilters: true,
    inlineEditing: true,
    columnVisibility: true,
    exportExcel: true,
    resetFilters: true,
    compactMode: true,
    rowStyling: true
  },

  // Debug settings
  debug: {
    enabled: false,
    logLevel: 'info'
  }
};

// ==========================================
// MODULE INITIALIZATION
// ==========================================

/**
 * Initialize Sales module using the central initializer
 */
function initializeSalesModule() {
  if (typeof window.autoInitializeDataTablesModule === 'function') {
    window.autoInitializeDataTablesModule(SALES_CONFIG);
  } else {
    console.error('DataTables module initializer not found. Make sure module-initializer.js is loaded first.');
  }
}

// Auto-initialize when DOM is ready
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initializeSalesModule);
} else {
  setTimeout(initializeSalesModule, 50);
}

// ==========================================
// EXPORT CONFIGURATION
// ==========================================

// Export configuration for external use
window.SALES_CONFIG = SALES_CONFIG;

// Export initialization function for manual use
window.initializeSalesModule = initializeSalesModule;
//# sourceMappingURL=sales_listssp.b2fc2420.js.map