/**
 * JavaScript za inicijalizaciju datepickera na obrascu za uređivanje zadataka
 */
$(function () {
    // Inicijalizacija svih datepickera
    const datePickers = [
        {
            id: "#ticket_arrdate_input",
            options: {
                dateFormat: "d-m-Y H:i",
                enableTime: true,
                time_24hr: true,
                locale: "hr",
                allowInput: true,
                disableMobile: true,
                appendTo: document.body,
                position: "auto"
            }
        },
        {
            id: "#ticket_taken_input",
            options: {
                dateFormat: "d-m-Y H:i",
                enableTime: true,
                time_24hr: true,
                locale: "hr",
                allowInput: true,
                disableMobile: true,
                appendTo: document.body,
                position: "auto"
            }
        },
        {
            id: "#ticket_resolved_input",
            options: {
                dateFormat: "d-m-Y H:i",
                enableTime: true,
                time_24hr: true,
                locale: "hr",
                allowInput: true,
                disableMobile: true,
                appendTo: document.body,
                position: "auto"
            }
        }
    ];
    
    // Inicijalizacija svakog datepickera
    datePickers.forEach(function(picker) {
        const element = $(picker.id);
        if (element.length) {
            const fp = flatpickr(element[0], picker.options);
            
            // Učini ikonu kalendara klikabilnom
            element.closest(".input-group").find(".input-group-text").on("click", function() {
                fp.open();
            });
        }
    });
});
//# sourceMappingURL=edittasks.14f3f2e4.js.map