/**
 * MyTasks Home JS
 * Handles tasks loading and interaction
 */

// Hardcoded route instead of getting from script attribute
const publicUrl = JSON.parse(document.getElementById('app-config').textContent).paths.app_url;
const fetchTasks = `${publicUrl}/mytasks/api/fetch-mytasks`;

$(document).ready(function() {

  var currentLimit = 5; // Initialize the currentLimit variable to the initial limit

  load_comment();

  function load_comment(menuItem, tip=null) {
    $.ajax({
      url: fetchTasks,
      method: "POST",
      data: {
        "menuItem": menuItem,
        "tip": tip,
        "currentLimit": currentLimit
      },
      success: function(data) {
        $('#display_comment').html(data);
      },
      error: function(xhr, status, error) {
        console.log('AJAX error:', error);
      }
    });
  }

  function load_comment_reply(commentId) {
    $.ajax({
      url: "home/fetch_comment_zaprofile.php",
      method: "POST",
      data: { commentId: commentId },
      success: function(data) {
        $('#display_comment_reply').html(data);
      },
      error: function(xhr, status, error) {
        console.log('AJAX error:', error);
      }
    });
  }

  // Submit event handler for the comment forms
  $('#comment_form, #comment_form2').on('submit', function(event) {
    event.preventDefault();
    var form_data = $(this).serialize();
    console.log('Form data:', form_data);
    var form_id = $(this).attr('id');
    var url = "";
    if (form_id === "comment_form") {
      url = "home/add_comment.php";
    } else if (form_id === "comment_form2") {
      url = "home/add_comment.php";
    }
    $.ajax({
      url: url,
      method: "POST",
      data: form_data,
      dataType: "JSON",
      success: function(data) {
        console.log(data);
        if (data.error != '') {
          $('#' + form_id)[0].reset();
          $('#comment_message').html(data.error);
          $('#' + form_id + ' input[name=comment_id]').val('0');
          load_comment();
          // Close the modal window
          $('#myModal').modal('hide');
        }
      },
      error: function(xhr, status, error) {
        console.log('AJAX error:', error);
      }
    });
  });

  $(document).on('click', '.tweet__footer span', function() {
    var comment_id = $(this).attr("id");
    var type = $(this).attr("id2");
    var form_id = "";
    if (type === "some_type") {
      form_id = "comment_form";
    } else {
      form_id = "comment_form2";
    }
    $('#' + form_id + ' input[name=comment_id]').val(comment_id);
    $('#' + form_id + ' input[name=type]').val(type);
    $('#' + form_id + ' textarea[name=comment_content]').focus();

    // Load comment reply
    load_comment_reply(comment_id);
  });

  // Add an event listener to all sidebar menu items
  $('.sidebar-menu__item').on('click', function() {
    var menuItem = $(this).attr("id");
    currentLimit = 5; // Reset currentLimit to 5
    load_comment(menuItem);
  });

  $(document).ready(function() {
    $('.sidebar-menu__item').on('click', function() {
      // Remove the 'sidebar-menu__item--active' class from all menu items
      $('.sidebar-menu__item').removeClass('sidebar-menu__item--active');

      // Add the 'sidebar-menu__item--active' class to the clicked menu item
      $(this).addClass('sidebar-menu__item--active');
    });
  });

  // Event handler for the "Load More" button koristeci hidden ids u div id asd za ucitavanje iz statusa
  $('#tweet-counter').on('click', function() {
    var menuItem2 = $('#brojticketa').data('id1');
    var tip = $('#brojticketa').data('id2');
    currentLimit += 5; // Povećaj currentLimit za 5
    load_comment(menuItem2, tip);
    // Koristite tip u ostatku vašeg koda...
  });

  // Add an event listener to main layout items ali s obzirom da se dinamicki generira mora ici ovako $(document).on('click', '.hashtag', function(e) {
  $(document).on('click', '.hashtag', function(e) {
      e.preventDefault();
      var menuItem2 = $(this).attr("id2");
      var tip = $(this).attr("id");
      currentLimit = 5; // Reset currentLimit to 5
      load_comment(menuItem2, tip);
  });

});
//# sourceMappingURL=mytasks_home.880d3122.js.map